/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.AngularUnit;
import com.esri.mo.cs.geod.BaseNamedGeodeticObject;
import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.CoordinateSystem;
import com.esri.mo.cs.geod.Datum;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GeodeticDatabase;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.Horizon;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.PrimeMeridian;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;

public class GeographicCoordinateSystem
extends BaseNamedGeodeticObject
implements CoordinateSystem {
    private int d;
    private boolean f;
    private double c;
    private PrimeMeridian b;
    private Datum e;
    private Unit a;
    public static GeographicCoordinateSystem WGS84_IN_RADIANS;
    public static GeographicCoordinateSystem WGS84;

    static {
        WGS84 = new GeographicCoordinateSystem(new AngularUnit("Decimal Degrees", " deg.", 3, Math.PI / 180), Datum.WGS84, PrimeMeridian.GREENWICH);
        WGS84_IN_RADIANS = new GeographicCoordinateSystem(new AngularUnit("Radians", " rads.", 5, 1.0), Datum.WGS84, PrimeMeridian.GREENWICH);
    }

    public Horizon getHorizon() {
        return null;
    }

    public boolean hasDatumTransformation() {
        return false;
    }

    public String getPECoordSysString() {
        return "GEOGCS[\"" + this.getName() + "\",DATUM[\"" + this.e.getName() + "\"," + this.e.getEllipsoid().getPEString() + "]," + this.b.getPEString() + "]";
    }

    public String getPEDatumString() {
        return "";
    }

    public void fromWGS84Geographic(Point3D point3D) throws CalculationException {
        if (this.f) {
            point3D.x = Utilities.angle180(point3D.x - this.c);
        }
        return;
    }

    public void toWGS84Geographic(Point3D point3D) throws CalculationException {
        if (this.f) {
            point3D.x = Utilities.angle180(point3D.x + this.c);
        }
        return;
    }

    public void fromGeographic(Point3D point3D) throws CalculationException {
        if (this.f) {
            point3D.x = Utilities.angle180(point3D.x - this.c);
        }
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        if (this.f) {
            point3D.x = Utilities.angle180(point3D.x + this.c);
        }
        return;
    }

    public PrimeMeridian getPrimeMeridian() {
        return this.b;
    }

    public Ellipsoid getEllipsoid() {
        return this.e.getEllipsoid();
    }

    public Datum getDatum() {
        return this.e;
    }

    public Unit getUnit() {
        return this.a;
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new GeographicCoordinateSystem(geodeticRow, n2);
    }

    public GeographicCoordinateSystem(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(geodeticRow, n2);
        try {
            this.d = Integer.parseInt(geodeticRow.getColumn(3 + n2));
            Ellipsoid ellipsoid = (Ellipsoid)GeodeticDatabase.getDatabase().getEllipsoidTable().getObject(geodeticRow.getColumn(4 + n2));
            this.e = new Datum(this._name, ellipsoid);
            this.a = (Unit)GeodeticDatabase.getDatabase().getAngularUnitTable().getObject(geodeticRow.getColumn(5 + n2));
            int n3 = this._name.indexOf(64);
            if (n3 == -1) {
                this.b = (PrimeMeridian)GeodeticDatabase.getDatabase().getAngularUnitTable().getObject("GREENWICH");
                this.c = 0.0;
                this.f = false;
            } else {
                this.b = (PrimeMeridian)GeodeticDatabase.getDatabase().getPrimeMeridianTable().getObject(this._name.substring(n3 + 1));
                this.c = this.b.getPrimeMeridian();
                this.f = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InvalidRowDataException(geodeticRow);
        }
    }

    public GeographicCoordinateSystem(Unit unit, Datum datum, PrimeMeridian primeMeridian) {
        this._name = new String(datum.getName());
        this._description = new String(datum.getDescription());
        this._longDescription = new String(datum.getLongDescription());
        this.a = unit;
        this.e = datum;
        this.b = primeMeridian;
        this.c = this.b.getPrimeMeridian();
        this.f = !Utilities.angleIsZero(this.c);
    }

    GeographicCoordinateSystem() {
    }
}

