/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.AngularUnit;
import com.esri.mo.cs.geod.BaseProjection;
import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Datum;
import com.esri.mo.cs.geod.DoubleEnvelopeHorizon;
import com.esri.mo.cs.geod.DoubleHorizon;
import com.esri.mo.cs.geod.EnvelopeHorizon;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.GeodeticTable;
import com.esri.mo.cs.geod.Horizon;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.LinearUnit;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.PrimeMeridian;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;

public class GenericProjection
extends BaseProjection {
    protected Horizon _horizon;
    private Object[] a;

    public GeodeticTable getTable() {
        return null;
    }

    public boolean hasSphereSolution() {
        return true;
    }

    public boolean hasEllipsoidalSolution() {
        return true;
    }

    protected void makeHorizon(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.makeHorizon(d2, d3, d6, d7);
        Horizon horizon = this._horizon;
        this.makeHorizon(d4, d5, d6, d7);
        this._horizon = new DoubleHorizon(horizon, this._horizon);
        return;
    }

    protected void makeHorizon(double d2, double d3, double d4, double d5) {
        this._horizon = d2 < -Math.PI ? new DoubleEnvelopeHorizon(-Math.PI, d3, d2 + Math.PI * 2, Math.PI, d4, d5) : (d3 > Math.PI ? new DoubleEnvelopeHorizon(-Math.PI, d3 - Math.PI * 2, d2, Math.PI, d4, d5) : new EnvelopeHorizon(d2, d3, d4, d5));
        return;
    }

    protected void makeHorizon(double d2, double d3, double d4) {
        this._horizon = Math.abs(d2) < 1.0E-14 ? new EnvelopeHorizon(-Math.PI, Math.PI, d3, d4) : (d2 > 0.0 ? new DoubleEnvelopeHorizon(-Math.PI, d2 - Math.PI, Math.PI, d3, d4) : new DoubleEnvelopeHorizon(-Math.PI, d2 + Math.PI, Math.PI, d3, d4));
        return;
    }

    public Horizon getHorizon() {
        return this._horizon;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new GenericProjection(unit, unit2, stringArray, n2, this.getSchema());
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new GenericProjection(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        GenericProjection genericProjection = null;
        genericProjection = (GenericProjection)super.clone();
        return genericProjection;
    }

    public String getPECoordSysString() {
        if (!this.isLatitudeLongitude()) {
            return "PROJCS[\"" + this.getName() + "\",GEOGCS[\"" + this._ellipsoid.getName() + "\",DATUM[\"" + this._ellipsoid.getName() + "\"," + this._ellipsoid.getPEString() + "]," + PrimeMeridian.GREENWICH.getPEString() + "," + this.getPEString() + "]]";
        }
        return "GEOGCS[\"" + this._ellipsoid.getName() + "\",DATUM[\"" + this._ellipsoid.getName() + "\"," + this._ellipsoid.getPEString() + "]," + PrimeMeridian.GREENWICH.getPEString() + "]";
    }

    public PrimeMeridian getPrimeMeridian() {
        return PrimeMeridian.GREENWICH;
    }

    public boolean hasDatumTransformation() {
        return false;
    }

    public void fromWGS84Geographic(Point3D point3D) throws CalculationException {
        this.fromGeographic(point3D);
    }

    public void toWGS84Geographic(Point3D point3D) throws CalculationException {
        this.toGeographic(point3D);
    }

    public Datum getDatum() {
        return new Datum(this._ellipsoid.getName(), this._ellipsoid);
    }

    public String getPEDatumString() {
        return "";
    }

    public String getPEString() {
        if (this._angleUnit == null) {
            this._angleUnit = AngularUnit.DECIMAL_DEGREES;
        }
        if (this._linearUnit == null) {
            this._linearUnit = LinearUnit.METERS;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PROJECTION[\"");
        stringBuffer.append(this.getSchema().getPEProjectionName());
        stringBuffer.append("\"]");
        stringBuffer.append(this.getSchema().getPEString(this._angleUnit, this._linearUnit, this.getValues()));
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    public GenericProjection(Unit var1_1, Unit var2_2, String[] var3_3, int var4_4, ProjectionSchema var5_5) throws InvalidDataException {
        var7_6 = -1;
        super(var5_5);
        try {
            this._angleUnit = var1_1;
            this._linearUnit = var2_2;
            this._ellipsoid = null;
            this.a = new Object[var5_5.getNumberOfParameters()];
            var6_7 = 0;
            {
                switch (var7_6) {
                    case 1: {
                        continue block6;
                    }
                    while (true) {
                        this.a[var6_7] = var6_7 == 0 ? this._angleUnit : (var6_7 == 1 ? this._linearUnit : var5_5.convert(var3_3[var6_7 + var4_4], var6_7, this._angleUnit, this._linearUnit));
                        ++var6_7;
                        case 0: {
                            var7_6 = -1;
                        }
                        break;
                    }
                }
            }
            if (var6_7 < var5_5.getNumberOfParameters()) ** continue;
            if (this._linearUnit == null) {
                this._linearUnit = this._angleUnit;
            }
        }
        catch (Exception var6_8) {
            var6_8.printStackTrace();
            throw new InvalidDataException();
        }
    }

    protected void assignValues() {
        this.a[0] = this._angleUnit;
        this.a[1] = this._linearUnit;
        return;
    }

    /*
     * Unable to fully structure code
     */
    public GenericProjection(ProjectionSchema var1_1, GeodeticRow var2_2, int var3_3) throws InvalidRowDataException {
        var5_4 = -1;
        super(var1_1);
        try {
            this._angleUnit = null;
            this._linearUnit = null;
            this._ellipsoid = null;
            this.a = new Object[var1_1.getNumberOfParameters()];
            var4_5 = 0;
            {
                switch (var5_4) {
                    case 1: {
                        continue block6;
                    }
                    while (true) {
                        this.a[var4_5] = var1_1.convert(var2_2.getColumn(var4_5 + var3_3), var4_5, this._angleUnit, this._linearUnit);
                        if (var4_5 == 0) {
                            this._angleUnit = (Unit)this.a[var4_5];
                        } else if (var4_5 == 1) {
                            this._linearUnit = (Unit)this.a[var4_5];
                        }
                        ++var4_5;
                        case 0: {
                            var5_4 = -1;
                        }
                        break;
                    }
                }
            }
            if (var4_5 < var1_1.getNumberOfParameters()) ** continue;
            if (this._linearUnit == null) {
                this._linearUnit = this._angleUnit;
            }
        }
        catch (Exception var4_6) {
            var4_6.printStackTrace();
            throw new InvalidRowDataException(var2_2);
        }
    }

    GenericProjection(ProjectionSchema projectionSchema) {
        super(projectionSchema);
    }

    GenericProjection() {
    }

    public Object getParameterValue(int n2) {
        this.getValues();
        if (this.a != null && n2 < this.a.length) {
            return this.a[n2];
        }
        return null;
    }

    protected void setValue(int n2, double d2) {
        this.getValues();
        this.a[n2] = new Double(d2);
        return;
    }

    protected double getValue(int n2) {
        return (Double)this.getParameterValue(n2);
    }

    protected Object[] getValues() {
        if (this.a == null) {
            this.a = new Object[this.getSchema().getNumberOfParameters()];
            this.assignValues();
        }
        return this.a;
    }
}

