/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class GallCylindrical
extends GenericProjection {
    private static double d = Math.cos(0.7853981633974483);
    private double a;
    private double b;
    private double c;

    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2 = Utilities.longitude180(point3D.x - this.c);
        point3D.x = this._ellipsoid.getRadius() * d2 * d + this.b;
        point3D.y = this._ellipsoid.getRadius() * (1.0 + d) * Math.tan(point3D.y / 2.0) + this.a;
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        point3D.y -= this.a;
        point3D.x -= this.b;
        point3D.y = 2.0 * Math.atan(point3D.y / (this._ellipsoid.getRadius() * (1.0 + d)));
        point3D.x = this.c + point3D.x / (this._ellipsoid.getRadius() * d);
        return;
    }

    public void init() throws ValidationException {
        this.makeHorizon(this.c, -1.5707963267948966, 1.5707963267948966);
        return;
    }

    public GallCylindrical(Ellipsoid ellipsoid, double d2, double d3, double d4) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.b = d3;
        this.a = d4;
        this.c = d2;
        this.init();
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new GallCylindrical(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        GallCylindrical gallCylindrical = null;
        gallCylindrical = (GallCylindrical)super.clone();
        gallCylindrical.c = this.c;
        gallCylindrical.a = this.a;
        gallCylindrical.b = this.b;
        try {
            gallCylindrical.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return gallCylindrical;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new GallCylindrical(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this.c);
        this.setValue(3, this.b);
        this.setValue(4, this.a);
        return;
    }

    private void a() {
        this.c = this.getValue(2);
        this.b = this.getValue(3);
        this.a = this.getValue(4);
        return;
    }

    public GallCylindrical(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public GallCylindrical(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    GallCylindrical() {
    }
}

