/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.BaseUnit;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.ValidationException;

public abstract class FactorBasedUnit
extends BaseUnit
implements Unit {
    protected double _toMKS;

    public String getPEString() {
        return "UNIT[\"" + this.getName() + "\"," + Double.toString(this._toMKS) + "]";
    }

    public String convertFromMKSToString(double d2) {
        return Double.toString(this.convertFromMKS(d2));
    }

    public double convertToMKS(String string) throws ValidationException, NumberFormatException {
        double d2 = Double.parseDouble(string);
        return this.convertToMKS(d2);
    }

    public double convertFromMKS(double d2) {
        return d2 / this._toMKS;
    }

    public double convertToMKS(double d2) throws ValidationException {
        return d2 * this._toMKS;
    }

    public FactorBasedUnit(String string, String string2, int n2, double d2) {
        super(string, string2, n2);
        this._toMKS = d2;
    }

    public FactorBasedUnit(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(geodeticRow, n2);
    }

    FactorBasedUnit() {
        this._toMKS = 1.0;
    }
}

