/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;
import com.esri.mo.cs.geod.ValidationMessageException;
import com.esri.mo.util.Resource;

public class EquidistantConic
extends GenericProjection {
    private double c;
    private double i;
    private double d;
    private double e;
    private double h;
    private double f;
    private double g;
    private double a;
    private double b;

    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2;
        double d3;
        if (this._ellipsoid.isSphere()) {
            d3 = this._ellipsoid.getRadius() * (this.i - point3D.y);
        } else {
            d2 = this._ellipsoid.meridianDistance(point3D.y);
            d3 = this._ellipsoid.semiMajor() * this.i - d2;
        }
        d2 = this.d * Utilities.longitude180(point3D.x - this.e);
        point3D.x = d3 * Math.sin(d2) + this.b;
        point3D.y = this.a + this.c - d3 * Math.cos(d2);
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        point3D.y -= this.a;
        point3D.x -= this.b;
        double d2 = Math.atan(point3D.x / (this.c - point3D.y));
        double d3 = this.c - point3D.y;
        double d4 = Math.sqrt(point3D.x * point3D.x + d3 * d3);
        if (this._ellipsoid.isSphere()) {
            point3D.y = this.i - d4 / this._ellipsoid.getRadius();
        } else {
            double d5 = this._ellipsoid.semiMajor() * this.i - d4;
            double d6 = this._ellipsoid.meridianDistanceToRectifying(d5);
            point3D.y = this._ellipsoid.rectifyingToLatitude(d6);
        }
        point3D.x = this.e + d2 / this.d;
        return;
    }

    public void init() throws ValidationException {
        if (this._ellipsoid == null) {
            return;
        }
        if (Utilities.angleIsZero(this.g) || Utilities.angleIsZero(this.f)) {
            throw new ValidationMessageException(Resource.getBundleText("ECNorthAndSouth"));
        }
        this.makeHorizon(this.e, -1.5707963267948966, 1.5707963267948966);
        if (this._ellipsoid.isSphere()) {
            double d2 = Math.cos(this.g);
            this.d = Utilities.angleIsZero(this.f - this.g) ? Math.sin(this.g) : (d2 - Math.cos(this.f)) / (this.f - this.g);
            this.i = d2 / this.d + this.g;
            this.c = this._ellipsoid.getRadius() * (this.i - this.h);
        } else {
            double d3 = this._ellipsoid.m(this.g);
            double d4 = this._ellipsoid.m(this.f);
            double d5 = this._ellipsoid.meridianDistance(this.h);
            double d6 = this._ellipsoid.meridianDistance(this.g);
            double d7 = this._ellipsoid.meridianDistance(this.f);
            this.d = Utilities.angleIsZero(this.f - this.g) ? Math.sin(this.g) : this._ellipsoid.semiMajor() * (d3 - d4) / (d7 - d6);
            this.i = d3 / this.d + d6 / this._ellipsoid.semiMajor();
            this.c = this._ellipsoid.semiMajor() * this.i - d5;
        }
        return;
    }

    public EquidistantConic(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5, double d6, double d7) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.b = d6;
        this.a = d7;
        this.e = d2;
        this.h = d3;
        this.g = d4;
        this.f = d5;
        this.init();
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new EquidistantConic(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        EquidistantConic equidistantConic = null;
        equidistantConic = (EquidistantConic)super.clone();
        equidistantConic.e = this.e;
        equidistantConic.h = this.h;
        equidistantConic.g = this.g;
        equidistantConic.f = this.f;
        equidistantConic.a = this.a;
        equidistantConic.b = this.b;
        try {
            equidistantConic.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return equidistantConic;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new EquidistantConic(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this.e);
        this.setValue(3, this.h);
        this.setValue(4, this.g);
        this.setValue(5, this.f);
        this.setValue(6, this.b);
        this.setValue(7, this.a);
        return;
    }

    private void a() {
        this.e = this.getValue(2);
        this.g = this.getValue(4);
        this.f = this.getValue(5);
        this.h = this.getValue(3);
        this.b = this.getValue(6);
        this.a = this.getValue(7);
        return;
    }

    public EquidistantConic(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public EquidistantConic(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    EquidistantConic() {
    }
}

