/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.BaseNamedGeodeticObject;
import com.esri.mo.cs.geod.GeodesyMath;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.GeodeticTable;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.PENamedObject;

public class Ellipsoid
extends BaseNamedGeodeticObject
implements PENamedObject {
    public static final Ellipsoid WGS84 = new Ellipsoid("WGS84", 6378137.0, 298.257223563);
    private boolean h;
    private int a;
    private double t;
    private double u;
    private double v;
    private double w;
    private double x;
    private double y;
    private double z;
    private double ab;
    private double bb;
    private double cb;
    private double db;
    private double k;
    private double l;
    private double m;
    private double n;
    private double o;
    private double p;
    private double q;
    private double r;
    private double s;
    private double e;
    private double g;
    private double b;
    private double c;
    private double i;
    private double d;
    private double f;
    private double j;

    public GeodeticTable getTable() {
        return this._table;
    }

    public double conformalLatitudeToLatitude(double d2) {
        return d2 + GeodesyMath.evenSineSeries(d2, this.w, this.v, this.u, this.t);
    }

    public double conformalLatitude(double d2) {
        return d2 + GeodesyMath.evenSineSeries(d2, this.ab, this.z, this.y, this.x);
    }

    public double m(double d2) {
        double d3 = this.g * Math.sin(d2);
        return Math.cos(d2) / Math.sqrt(1.0 - d3 * d3);
    }

    public double authalicToLatitude(double d2) {
        return d2 + GeodesyMath.evenSineSeries(d2, this.db, this.cb, this.bb);
    }

    public double authalicR() {
        if (this.isSphere()) {
            return this.getRadius();
        }
        return this.j * Math.sqrt(this.calcQ(1.5707963267948966) / 2.0);
    }

    public double calcQ(double d2) {
        double d3 = Math.sin(d2);
        double d4 = d3 * this.g;
        return (1.0 - this.f) * (d3 / (1.0 - d4 * d4) - 1.0 / (2.0 * this.g) * Math.log((1.0 - d4) / (1.0 + d4)));
    }

    public double rectifyingToLatitude(double d2) {
        return d2 + GeodesyMath.evenSineSeries(d2, this.n, this.m, this.l, this.k);
    }

    public double meridianDistanceToRectifying(double d2) {
        return 1.5707963267948966 * d2 / this.o;
    }

    public double meridianDistanceToPole() {
        return this.o;
    }

    public double rectifyingLatitude(double d2) {
        return this.meridianDistance(d2) * 1.5707963267948966 / this.o;
    }

    public double meridianDistancePrime(double d2) {
        return GeodesyMath.evenCosineSeries(d2, this.s, -2.0 * this.r, 4.0 * this.q, -6.0 * this.p);
    }

    public double meridianDistance(double d2) {
        return this.j * (this.s * d2 + GeodesyMath.evenSineSeries(d2, -this.r, this.q, -this.p));
    }

    public String getPEString() {
        return "SPHEROID[\"" + this.getPEName() + "\"," + this.semiMajor() + "," + this.inverseFlattening() + "]";
    }

    public double isometricLatitude(double d2) {
        double d3 = this.g * Math.sin(d2);
        return Math.log(Math.tan(0.7853981633974483 + d2 / 2.0) * Math.pow((1.0 - d3) / (1.0 + d3), this.g / 2.0));
    }

    public double radiusOfCurvatureR(double d2) {
        double d3 = Math.sin(d2);
        d3 *= d3;
        double d4 = 1.0 - this.f * d3;
        return this.j * (1.0 - this.f) / (d4 * Math.sqrt(d4));
    }

    public double radiusOfCurvatureN(double d2) {
        double d3 = Math.sin(d2);
        d3 *= d3;
        return this.j / Math.sqrt(1.0 - this.f * d3);
    }

    public double inverseFlattening() {
        return this.b;
    }

    public double flattening() {
        return this.c;
    }

    public double semiMinor() {
        return this.i;
    }

    public double eccentricityPrimeSquared() {
        return this.d;
    }

    public double eccentricityPrime() {
        return this.e;
    }

    public double eccentricitySquared() {
        return this.f;
    }

    public double eccentricity() {
        return this.g;
    }

    public double semiMajor() {
        return this.j;
    }

    private void a(double d2, double d3) {
        this.j = d2;
        this.b = d3;
        if (this.b == 0.0) {
            this.i = this.j;
            this.h = true;
        } else {
            this.h = false;
            this.c = 1.0 / d3;
            this.f = this.c * 2.0 - this.c * this.c;
            this.g = Math.sqrt(this.f);
            this.i = this.j * (1.0 - this.c);
            this.d = this.f / (1.0 - this.f);
            this.e = Math.sqrt(this.d);
            double d4 = this.f * this.f;
            double d5 = d4 * this.f;
            double d6 = d4 * d4;
            this.s = 1.0 - 0.25 * this.f - 0.046875 * d4 - 0.01953125 * d5;
            this.r = 0.375 * this.f + 0.09375 * d4 + 0.0439453125 * d5;
            this.q = 0.05859375 * d4 + 0.0439453125 * d5;
            this.p = 0.011393229166666666 * d5;
            this.o = this.j * this.s * 1.5707963267948966;
            double d7 = Math.sqrt(1.0 - this.f);
            double d8 = (1.0 - d7) / (1.0 + d7);
            double d9 = d8 * d8;
            double d10 = d9 * d8;
            double d11 = d9 * d9;
            this.n = 1.5 * d8 - 0.84375 * d10;
            this.m = 1.3125 * d9 - 1.71875 * d11;
            this.l = 151.0 * d10 / 96.0;
            this.k = 1097.0 * d11 / 512.0;
            this.db = this.f / 3.0 + 31.0 * d4 / 180.0 + 517.0 * d5 / 5040.0;
            this.cb = 23.0 * d4 / 360.0 + 251.0 * d5 / 3780.0;
            this.bb = 761.0 * d5 / 45360.0;
            this.ab = -(this.f * 0.5 + 5.0 * d4 / 24.0 + 3.0 * d5 / 32.0 + 281.0 * d6 / 5760.0);
            this.z = 5.0 * d4 / 48.0 + 7.0 * d5 / 80.0 + 697.0 * d6 / 11520.0;
            this.y = -(13.0 * d5 / 480.0 + 461.0 * d6 / 13440.0);
            this.x = 1237.0 * d6 / 161280.0;
            this.w = this.f * 0.5 + 5.0 * d4 / 24.0 + d5 / 12.0 + 13.0 * d6 / 360.0;
            this.v = 7.0 * d4 / 48.0 + 29.0 * d5 / 240.0 + 811.0 * d6 / 11520.0;
            this.u = 7.0 * d5 / 120.0 + 81.0 * d6 / 1120.0;
            this.t = 4279.0 * d6 / 161280.0;
        }
        return;
    }

    public Ellipsoid(String string, double d2, double d3) {
        this._name = string;
        this.a(d2, d3);
    }

    public Ellipsoid(double d2, double d3, boolean bl) {
        this.a(d2, 1.0 / (1.0 - Math.sqrt(1.0 - d3)));
    }

    public Ellipsoid(double d2, double d3) {
        this.a(d2, d3);
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new Ellipsoid(geodeticRow, n2);
    }

    public double getRadius() {
        return this.j;
    }

    public boolean isSphere() {
        return this.h;
    }

    public int getPENumber() {
        return this.a;
    }

    public String getPEName() {
        return this.getName();
    }

    public Ellipsoid(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(geodeticRow, n2);
        try {
            this.j = Double.parseDouble(geodeticRow.getColumn(3 + n2));
            this.b = Double.parseDouble(geodeticRow.getColumn(4 + n2));
        }
        catch (Exception exception) {
            throw new InvalidRowDataException(geodeticRow);
        }
        this.a(this.j, this.b);
    }

    Ellipsoid() {
    }

    public Object clone() {
        Ellipsoid ellipsoid = null;
        ellipsoid = (Ellipsoid)super.clone();
        ellipsoid.a(this.j, this.b);
        return ellipsoid;
    }
}

