/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class Eckert6
extends GenericProjection {
    private static double d = Math.sqrt(5.141592653589793);
    private double c;
    private double a;
    private double b;

    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2;
        double d3 = Utilities.longitude180(point3D.x - this.c);
        double d4 = point3D.y;
        double d5 = Math.sin(point3D.y);
        do {
            d2 = -(d4 + Math.sin(d4) - 2.5707963267948966 * d5) / (1.0 + Math.cos(d4));
            d4 += d2;
        } while (Math.abs(d2) > 1.0E-12);
        point3D.x = this._ellipsoid.getRadius() * d3 * (1.0 + Math.cos(d4)) / d + this.b;
        point3D.y = 2.0 * this._ellipsoid.getRadius() * d4 / d + this.a;
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        point3D.y -= this.a;
        point3D.x -= this.b;
        double d2 = d * point3D.y / (2.0 * this._ellipsoid.getRadius());
        point3D.y = Math.asin((d2 + Math.sin(d2)) / 2.5707963267948966);
        point3D.x = this.c + d * point3D.x / (this._ellipsoid.getRadius() * (1.0 + Math.cos(d2)));
        return;
    }

    public void init() throws ValidationException {
        this.makeHorizon(this.c, -1.5707963267948966, 1.5707963267948966);
        return;
    }

    public Eckert6(Ellipsoid ellipsoid, double d2, double d3, double d4) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.b = d3;
        this.a = d4;
        this.c = d2;
        this.init();
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new Eckert6(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        Eckert6 eckert6 = null;
        eckert6 = (Eckert6)super.clone();
        eckert6.c = this.c;
        eckert6.a = this.a;
        eckert6.b = this.b;
        try {
            eckert6.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return eckert6;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new Eckert6(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this.c);
        this.setValue(3, this.b);
        this.setValue(4, this.a);
        return;
    }

    private void a() {
        this.c = this.getValue(2);
        this.b = this.getValue(3);
        this.a = this.getValue(4);
        return;
    }

    public Eckert6(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public Eckert6(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    Eckert6() {
    }
}

