/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.axl.client.csg3CatchImpl;
import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class Eckert5
extends GenericProjection {
    private static double d = Math.sqrt(5.141592653589793);
    private double c;
    private double a;
    private double b;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        try {
            Eckert5 eckert5 = new Eckert5(new Ellipsoid(1.0, 0.0), Utilities.decimalDegreesToRadians(-90.0), 0.0, 0.0);
            Point3D point3D = new Point3D(Utilities.decimalDegreesToRadians(-75.0), Utilities.decimalDegreesToRadians(-50.0), 0.0);
            eckert5.fromGeographic(point3D);
            System.out.println(point3D.x + "," + point3D.y);
            eckert5.toGeographic(point3D);
            System.out.println(Utilities.radiansToDecimalDegrees(point3D.x) + ", " + Utilities.radiansToDecimalDegrees(point3D.y));
            return;
        }
        catch (Exception exception) {
            // empty catch block
            return;
        }
        catch (csg3CatchImpl csg3CatchImpl2) {
            throw csg3CatchImpl2;
        }
    }

    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2 = Utilities.longitude180(point3D.x - this.c);
        point3D.x = this.b + this._ellipsoid.getRadius() * (1.0 + Math.cos(point3D.y)) * d2 / d;
        point3D.y = this.a + 2.0 * this._ellipsoid.getRadius() * point3D.y / d;
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        point3D.y -= this.a;
        point3D.x -= this.b;
        point3D.y = d * point3D.y / (2.0 * this._ellipsoid.getRadius());
        double d2 = d * point3D.x / (this._ellipsoid.getRadius() * (1.0 + Math.cos(point3D.y)));
        point3D.x = Utilities.longitude180(this.c + d2);
        return;
    }

    public void init() throws ValidationException {
        this.makeHorizon(this.c, -1.5707963267948966, 1.5707963267948966);
        return;
    }

    public Eckert5(Ellipsoid ellipsoid, double d2, double d3, double d4) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.b = d3;
        this.a = d4;
        this.c = d2;
        this.init();
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new Eckert5(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        Eckert5 eckert5 = null;
        eckert5 = (Eckert5)super.clone();
        eckert5.c = this.c;
        eckert5.a = this.a;
        eckert5.b = this.b;
        try {
            eckert5.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return eckert5;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new Eckert5(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this.c);
        this.setValue(3, this.b);
        this.setValue(4, this.a);
        return;
    }

    private void a() {
        this.c = this.getValue(2);
        this.b = this.getValue(3);
        this.a = this.getValue(4);
        return;
    }

    public Eckert5(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public Eckert5(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    Eckert5() {
    }
}

