/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.axl.client.csg3CatchImpl;
import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class Eckert3
extends GenericProjection {
    private double e;
    private double c;
    private static double f = Math.sqrt(22.43597501544853);
    private double d;
    private double a;
    private double b;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        try {
            Eckert3 eckert3 = new Eckert3(new Ellipsoid(1.0, 0.0), Utilities.decimalDegreesToRadians(-90.0), 0.0, 0.0);
            Point3D point3D = new Point3D(Utilities.decimalDegreesToRadians(-75.0), Utilities.decimalDegreesToRadians(-50.0), 0.0);
            eckert3.fromGeographic(point3D);
            System.out.println(point3D.x + "," + point3D.y);
            eckert3.toGeographic(point3D);
            System.out.println(Utilities.radiansToDecimalDegrees(point3D.x) + ", " + Utilities.radiansToDecimalDegrees(point3D.y));
            return;
        }
        catch (Exception exception) {
            // empty catch block
            return;
        }
        catch (csg3CatchImpl csg3CatchImpl2) {
            throw csg3CatchImpl2;
        }
    }

    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2 = Utilities.longitude180(point3D.x - this.d);
        double d3 = point3D.y / 1.5707963267948966;
        double d4 = d3 * d3;
        d4 = d4 >= 1.0 ? 0.0 : Math.sqrt(1.0 - d4);
        point3D.x = d2 * this.c * (1.0 + d4) + this.b;
        point3D.y = this.a + point3D.y * this.e;
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        point3D.y -= this.a;
        point3D.x -= this.b;
        point3D.y /= this.e;
        double d2 = 2.0 * point3D.y / Math.PI;
        double d3 = d2 * d2;
        d3 = d3 >= 1.0 ? 0.0 : Math.sqrt(1.0 - d3);
        point3D.x = Utilities.longitude180(this.d + point3D.x / this.c / (1.0 + d3));
        return;
    }

    public void init() throws ValidationException {
        this.c = this._ellipsoid.getRadius() * 2.0 / f;
        this.e = this._ellipsoid.getRadius() * 4.0 / f;
        this.makeHorizon(this.d, -1.5707963267948966, 1.5707963267948966);
        return;
    }

    public Eckert3(Ellipsoid ellipsoid, double d2, double d3, double d4) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.b = d3;
        this.a = d4;
        this.d = d2;
        this.init();
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new Eckert3(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        Eckert3 eckert3 = null;
        eckert3 = (Eckert3)super.clone();
        eckert3.d = this.d;
        eckert3.a = this.a;
        eckert3.b = this.b;
        try {
            eckert3.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return eckert3;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new Eckert3(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this.d);
        this.setValue(3, this.b);
        this.setValue(4, this.a);
        return;
    }

    private void a() {
        this.d = this.getValue(2);
        this.b = this.getValue(3);
        this.a = this.getValue(4);
        return;
    }

    public Eckert3(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public Eckert3(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    Eckert3() {
    }
}

