/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.axl.client.csg3CatchImpl;
import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class Eckert2
extends GenericProjection {
    private static double d;
    private static double e;
    private double c;
    private double a;
    private double b;

    static {
        e = Math.sqrt(Math.PI * 6);
        d = Math.sqrt(2.0943951023931953);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        try {
            Eckert2 eckert2 = new Eckert2(new Ellipsoid(1.0, 0.0), Utilities.decimalDegreesToRadians(-90.0), 0.0, 0.0);
            Point3D point3D = new Point3D(Utilities.decimalDegreesToRadians(-75.0), Utilities.decimalDegreesToRadians(-50.0), 0.0);
            eckert2.fromGeographic(point3D);
            System.out.println(point3D.x + "," + point3D.y);
            eckert2.toGeographic(point3D);
            System.out.println(Utilities.radiansToDecimalDegrees(point3D.x) + ", " + Utilities.radiansToDecimalDegrees(point3D.y));
            return;
        }
        catch (Exception exception) {
            // empty catch block
            return;
        }
        catch (csg3CatchImpl csg3CatchImpl2) {
            throw csg3CatchImpl2;
        }
    }

    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2 = Utilities.longitude180(point3D.x - this.c);
        double d3 = Math.sqrt(4.0 - 3.0 * Math.sin(Math.abs(point3D.y)));
        point3D.x = this.b + this._ellipsoid.getRadius() * 2.0 * d3 * d2 / e;
        point3D.y = this._ellipsoid.getRadius() * d * Utilities.signum(point3D.y) * (2.0 - d3) + this.a;
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        point3D.y -= this.a;
        point3D.x -= this.b;
        double d2 = 2.0 - Math.abs(point3D.y) / (this._ellipsoid.getRadius() * d);
        double d3 = (4.0 - d2 * d2) / 3.0;
        if (Math.abs(d3) > 1.0) {
            d3 = Utilities.signum(d3);
        }
        point3D.y = Utilities.signum(point3D.y) * Math.asin(d3);
        point3D.x = Utilities.longitude180(this.c + e * point3D.x / (this._ellipsoid.getRadius() * 2.0 * d2));
        return;
    }

    public void init() throws ValidationException {
        this.makeHorizon(this.c, -1.5707963267948966, 1.5707963267948966);
        return;
    }

    public Eckert2(Ellipsoid ellipsoid, double d2, double d3, double d4) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.b = d3;
        this.a = d4;
        this.c = d2;
        this.init();
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new Eckert2(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        Eckert2 eckert2 = null;
        eckert2 = (Eckert2)super.clone();
        eckert2.c = this.c;
        eckert2.a = this.a;
        eckert2.b = this.b;
        try {
            eckert2.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return eckert2;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new Eckert2(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this.c);
        this.setValue(3, this.b);
        this.setValue(4, this.a);
        return;
    }

    private void a() {
        this.c = this.getValue(2);
        this.b = this.getValue(3);
        this.a = this.getValue(4);
        return;
    }

    public Eckert2(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public Eckert2(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    Eckert2() {
    }
}

