/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.axl.client.csg3CatchImpl;
import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class Eckert1
extends GenericProjection {
    private double d;
    private static double e = 2.0 * Math.sqrt(0.2122065907891938);
    private double c;
    private double a;
    private double b;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        try {
            Eckert1 eckert1 = new Eckert1(new Ellipsoid(1.0, 0.0), Utilities.decimalDegreesToRadians(-90.0), 0.0, 0.0);
            Point3D point3D = new Point3D(Utilities.decimalDegreesToRadians(-75.0), Utilities.decimalDegreesToRadians(-50.0), 0.0);
            eckert1.fromGeographic(point3D);
            System.out.println(point3D.x + "," + point3D.y);
            eckert1.toGeographic(point3D);
            System.out.println(Utilities.radiansToDecimalDegrees(point3D.x) + ", " + Utilities.radiansToDecimalDegrees(point3D.y));
            return;
        }
        catch (Exception exception) {
            // empty catch block
            return;
        }
        catch (csg3CatchImpl csg3CatchImpl2) {
            throw csg3CatchImpl2;
        }
    }

    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2 = Utilities.longitude180(point3D.x - this.c);
        point3D.x = this.d * d2 * (1.0 - Math.abs(point3D.y) / Math.PI) + this.b;
        point3D.y = this.d * point3D.y + this.a;
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        point3D.y -= this.a;
        point3D.x -= this.b;
        point3D.y /= this.d;
        point3D.x = Utilities.longitude180(this.c + point3D.x / (this.d * (1.0 - Math.abs(point3D.y) / Math.PI)));
        return;
    }

    public void init() throws ValidationException {
        this.d = this._ellipsoid.getRadius() * e;
        this.makeHorizon(this.c, -1.5707963267948966, 1.5707963267948966);
        return;
    }

    public Eckert1(Ellipsoid ellipsoid, double d2, double d3, double d4) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.b = d3;
        this.a = d4;
        this.c = d2;
        this.init();
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new Eckert1(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        Eckert1 eckert1 = null;
        eckert1 = (Eckert1)super.clone();
        eckert1.c = this.c;
        eckert1.a = this.a;
        eckert1.b = this.b;
        try {
            eckert1.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return eckert1;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new Eckert1(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this.c);
        this.setValue(3, this.b);
        this.setValue(4, this.a);
        return;
    }

    private void a() {
        this.c = this.getValue(2);
        this.b = this.getValue(3);
        this.a = this.getValue(4);
        return;
    }

    public Eckert1(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public Eckert1(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    Eckert1() {
    }
}

