/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Stereographic;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class DoubleStereographic
extends GenericProjection {
    private Stereographic c;
    private double f;
    private double g;
    private double h;
    private double e;
    private double d;
    private double a;
    private double b;

    public static void main(String[] stringArray) {
        try {
            DoubleStereographic doubleStereographic = new DoubleStereographic(Ellipsoid.WGS84, Utilities.decimalDegreesToRadians(-90.0), Utilities.decimalDegreesToRadians(-20.0), 1.0, 0.0, 0.0);
            Point3D point3D = new Point3D(Utilities.decimalDegreesToRadians(-90.0), Utilities.decimalDegreesToRadians(-10.0), 0.0);
            doubleStereographic.fromGeographic(point3D);
            System.out.println(point3D.x + "," + point3D.y);
            doubleStereographic.toGeographic(point3D);
            System.out.println(Utilities.radiansToDecimalDegrees(point3D.x) + ", " + Utilities.radiansToDecimalDegrees(point3D.y));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return;
    }

    public void fromGeographic(Point3D point3D) throws CalculationException {
        if (!this._ellipsoid.isSphere()) {
            double d2 = point3D.y;
            double d3 = point3D.x;
            if (Utilities.angleIsHalfPi(d2)) {
                point3D.y = 1.5707963267948966;
            } else {
                double d4 = Math.sin(d2);
                double d5 = this._ellipsoid.eccentricity();
                point3D.y = 2.0 * Math.atan(this.g * Math.pow(Math.tan(0.7853981633974483 + d2 / 2.0) * Math.pow((1.0 - d5 * d4) / (1.0 + d5 * d4), d5 / 2.0), this.h)) - 1.5707963267948966;
            }
            point3D.x = this.h * d3;
        }
        this.c.fromGeographic(point3D);
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        this.c.toGeographic(point3D);
        if (!this._ellipsoid.isSphere()) {
            double d2 = point3D.y;
            double d3 = point3D.x;
            double d4 = d3 / this.h;
            double d5 = d2;
            if (Utilities.angleIsHalfPi(d2)) {
                d5 = 1.5707963267948966;
            } else {
                double d6 = d2;
                boolean bl = true;
                int n2 = 1;
                double d7 = this._ellipsoid.eccentricity();
                double d8 = this._ellipsoid.eccentricitySquared();
                while (bl) {
                    double d9;
                    if (Utilities.angleIsHalfPi(Math.abs(d6))) {
                        d5 = Utilities.signum(d5) * 1.5707963267948966;
                        d9 = 0.0;
                    } else {
                        double d10 = Math.sin(d6);
                        double d11 = Math.cos(d6);
                        double d12 = 0.7853981633974483 + d6 / 2.0;
                        double d13 = Math.tan(d12);
                        double d14 = Math.pow((1.0 - d7 * d10) / (1.0 + d7 * d10), d7 / 2.0);
                        double d15 = Math.cos(d12);
                        double d16 = this.g * Math.pow(d13 * d14, this.h) - Math.tan(0.7853981633974483 + d2 / 2.0);
                        double d17 = this.h * this.g * Math.pow(d13 * d14, this.h - 1.0) * (d14 * (0.5 / (d15 * d15) - d13 * (d8 * d11) / (1.0 - d8 * d10 * d10)));
                        d5 = d6 - d16 / d17;
                        d9 = d5 - d6;
                    }
                    if (Utilities.angleIsZero(d9) || n2 > 30) {
                        bl = false;
                        continue;
                    }
                    d6 = d5;
                    ++n2;
                }
            }
            point3D.x = d4;
            point3D.y = d5;
        }
        return;
    }

    public void init() throws ValidationException {
        if (this._ellipsoid.isSphere()) {
            this.c = new Stereographic(this._ellipsoid, this.e, this.d, this.f, this.b, this.a);
            this.c.init();
        } else {
            double d2;
            double d3;
            double d4;
            double d5 = this._ellipsoid.eccentricity();
            double d6 = this._ellipsoid.eccentricitySquared();
            if (Utilities.angleIsHalfPi(Math.abs(this.d))) {
                d4 = Utilities.signum(this.d);
                this.h = 1.0;
                this.g = Math.pow((1.0 + d5) / (1.0 - d5), d5 / 2.0);
                d3 = Utilities.signum(this.d) * 1.5707963267948966;
                d2 = this.e;
            } else {
                double d7 = Math.cos(this.d);
                d4 = Math.sin(this.d);
                this.h = Math.sqrt(1.0 + d6 * d7 * d7 * d7 * d7 / (1.0 - d6));
                d3 = Math.asin(d4 / this.h);
                d2 = this.h * this.e;
                this.g = Math.tan(0.7853981633974483 + d3 / 2.0) * Math.pow(Math.tan(0.7853981633974483 + this.d / 2.0) * Math.pow((1.0 - d5 * d4) / (1.0 + d5 * d4), d5 / 2.0), -this.h);
            }
            double d8 = this._ellipsoid.semiMajor();
            double d9 = 1.0 - d6 * d4 * d4;
            double d10 = d8 * (1.0 - d6) / Math.pow(d9, 1.5);
            double d11 = d8 / Math.sqrt(d9);
            double d12 = Math.sqrt(d10 * d11);
            this.c = new Stereographic(new Ellipsoid(d12, 0.0), d2, d3, this.f, this.b, this.a);
            this.c.init();
        }
        this.makeHorizon(this.e, -1.5707963267948966, 1.5707963267948966);
        return;
    }

    public DoubleStereographic(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5, double d6) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.b = d5;
        this.a = d6;
        this.e = d2;
        this.d = d3;
        this.f = d4;
        this.init();
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new DoubleStereographic(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        DoubleStereographic doubleStereographic = null;
        doubleStereographic = (DoubleStereographic)super.clone();
        doubleStereographic.e = this.e;
        doubleStereographic.d = this.d;
        doubleStereographic.a = this.a;
        doubleStereographic.b = this.b;
        doubleStereographic.f = this.f;
        try {
            doubleStereographic.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return doubleStereographic;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new DoubleStereographic(unit, unit2, stringArray, n2, this.getSchema());
    }

    public DoubleStereographic(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this.e);
        this.setValue(3, this.d);
        this.setValue(4, this.f);
        this.setValue(5, this.b);
        this.setValue(6, this.a);
        return;
    }

    private void a() {
        this.e = this.getValue(2);
        this.d = this.getValue(3);
        this.f = this.getValue(5);
        this.b = this.getValue(5);
        this.a = this.getValue(6);
        return;
    }

    public DoubleStereographic(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    DoubleStereographic() {
    }
}

