/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.BaseParameter;
import com.esri.mo.cs.geod.GeoDialogInfo;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.NumericField;
import com.esri.mo.cs.geod.Parameter;
import com.esri.mo.cs.geod.Unit;
import java.text.NumberFormat;
import javax.swing.JComponent;

public class DoubleParameter
extends BaseParameter
implements Parameter {
    public JComponent createComponent(GeoDialogInfo geoDialogInfo) throws InvalidDataException {
        return new NumericField(0.0, 0, NumberFormat.getInstance());
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new DoubleParameter(geodeticRow, n2);
    }

    public double convertDouble(String string, Unit unit, Unit unit2) throws InvalidDataException {
        try {
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            throw new InvalidDataException();
        }
    }

    public String convertFrom(Object object, Unit unit, Unit unit2) throws InvalidDataException {
        try {
            return ((Double)object).toString();
        }
        catch (Exception exception) {
            throw new InvalidDataException();
        }
    }

    public Object convert(String string, Unit unit, Unit unit2) throws InvalidDataException {
        try {
            return new Double(string);
        }
        catch (Exception exception) {
            throw new InvalidDataException();
        }
    }

    public DoubleParameter(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(geodeticRow, n2);
    }

    DoubleParameter() {
    }
}

