/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.BaseNamedGeodeticObject;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.PEObject;

public class Datum
extends BaseNamedGeodeticObject
implements PEObject {
    public static final Datum WGS84 = new Datum("WGS84", Ellipsoid.WGS84);
    private Ellipsoid a;

    public String getPEString() {
        return "DATUM[\"" + this.getName() + "\"," + this.getEllipsoid().getPEString() + "]";
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new Datum(geodeticRow, n2);
    }

    public Ellipsoid getEllipsoid() {
        return this.a;
    }

    public Datum(String string, Ellipsoid ellipsoid) {
        this.a = (Ellipsoid)ellipsoid.clone();
        this._name = new String(string);
        this._description = new String("");
        this._longDescription = new String("");
    }

    public Datum(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(geodeticRow, n2);
        if (geodeticRow.getLength() <= n2 + 3) {
            throw new InvalidRowDataException(geodeticRow);
        }
        this.a = (Ellipsoid)geodeticRow.getDatabase().getEllipsoidTable().getObject(geodeticRow.getColumn(3 + n2));
        if (this.a == null) {
            throw new InvalidRowDataException(geodeticRow);
        }
    }

    Datum() {
    }
}

