/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.BaseUnit;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class DMAngularUnit
extends BaseUnit
implements Unit {
    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new DMAngularUnit(geodeticRow, n2);
    }

    public String getPEString() {
        return null;
    }

    public String convertFromMKSToString(double d2) {
        return Double.toString(this.convertFromMKS(d2));
    }

    public double convertToMKS(String string) throws ValidationException, NumberFormatException {
        double d2 = Double.parseDouble(string);
        return this.convertToMKS(d2);
    }

    public double convertFromMKS(double d2) {
        return Utilities.radiansToDM(d2);
    }

    public double convertToMKS(double d2) throws ValidationException {
        return Utilities.DMToRadians(d2);
    }

    public DMAngularUnit(String string, String string2, int n2) {
        super(string, string2, n2);
    }

    public DMAngularUnit(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(geodeticRow, n2);
        if (geodeticRow.getLength() < 6) {
            throw new InvalidRowDataException(geodeticRow);
        }
        try {
            this._suffix = geodeticRow.getColumn(4);
            this._precision = Integer.parseInt(geodeticRow.getColumn(5));
        }
        catch (Exception exception) {
            throw new InvalidRowDataException(geodeticRow);
        }
    }

    DMAngularUnit() {
    }
}

