/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;
import com.esri.mo.cs.geod.ValidationMessageException;
import com.esri.mo.util.Resource;

public class CylindricalEqualAreaTransverseAspect
extends GenericProjection {
    private double c;
    private double h;
    private double f;
    private double g;
    private double a;
    private double b;
    private double d;
    private double e;

    public void fromGeographic(Point3D point3D) throws CalculationException {
        if (this._ellipsoid.isSphere()) {
            double d2 = Utilities.longitude180(point3D.x - this.d);
            point3D.x = this._ellipsoid.getRadius() / this.g * Math.cos(point3D.y) * Math.sin(d2);
            point3D.y = this._ellipsoid.getRadius() * this.g * (Math.atan(Math.tan(point3D.y) / Math.cos(d2)) - this.e);
        } else {
            double d3 = Utilities.longitude180(point3D.x - this.d);
            double d4 = this._ellipsoid.calcQ(point3D.y);
            double d5 = Math.asin(d4 / this.c);
            double d6 = Math.atan(Math.tan(d5) / Math.cos(d3));
            double d7 = this._ellipsoid.authalicToLatitude(d6);
            double d8 = Math.sin(d7);
            point3D.x = this._ellipsoid.semiMajor() * Math.cos(d5) * Math.cos(d7) * Math.sin(d3) / (this.g * Math.cos(d6) * Math.sqrt(1.0 - this._ellipsoid.eccentricitySquared() * d8 * d8)) + this.b;
            double d9 = this._ellipsoid.meridianDistance(d7);
            point3D.y = this.g * (d9 - this.h) + this.a;
        }
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        point3D.x -= this.b;
        point3D.y -= this.a;
        if (this._ellipsoid.isSphere()) {
            double d2 = point3D.y / (this._ellipsoid.getRadius() * this.g) + this.e;
            double d3 = this.g * point3D.x / this._ellipsoid.getRadius();
            double d4 = Math.sqrt(1.0 - d3 * d3);
            point3D.y = Math.asin(d4 * Math.sin(d2));
            point3D.x = this.d + Math.atan(d3 / (d4 * Math.cos(d2)));
        } else {
            double d5 = this.h + point3D.y / this.g;
            double d6 = this._ellipsoid.meridianDistanceToRectifying(d5);
            double d7 = this._ellipsoid.rectifyingToLatitude(d6);
            double d8 = this._ellipsoid.calcQ(d7);
            double d9 = Math.asin(d8 / this.c);
            double d10 = Math.cos(d9);
            double d11 = Math.sin(d7) * this._ellipsoid.eccentricity();
            double d12 = -Math.asin(this.g * point3D.x * d10 * Math.sqrt(1.0 - d11 * d11) / (this._ellipsoid.semiMajor() * Math.cos(d7)));
            double d13 = Math.asin(Math.cos(d12) * Math.sin(d9));
            point3D.y = this._ellipsoid.authalicToLatitude(d13);
            point3D.x = this.d - Math.atan(Math.tan(d12) / Math.cos(d9));
        }
        return;
    }

    public void init() throws ValidationException {
        if (this.g < 1.0E-12) {
            throw new ValidationMessageException(Resource.getBundleText("CEATAScaleFactor"));
        }
        if (this._ellipsoid == null) {
            return;
        }
        this.makeHorizon(this.d, -1.5707963267948966, 1.5707963267948966);
        if (!this._ellipsoid.isSphere()) {
            double d2 = this._ellipsoid.eccentricity();
            double d3 = this._ellipsoid.eccentricitySquared();
            double d4 = d3 * d3;
            double d5 = d4 * d3;
            this.c = this._ellipsoid.calcQ(1.5707963267948966);
            this.h = this._ellipsoid.meridianDistance(this.e);
        }
        return;
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new CylindricalEqualAreaTransverseAspect(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        CylindricalEqualAreaTransverseAspect cylindricalEqualAreaTransverseAspect = null;
        cylindricalEqualAreaTransverseAspect = (CylindricalEqualAreaTransverseAspect)super.clone();
        cylindricalEqualAreaTransverseAspect.d = this.d;
        cylindricalEqualAreaTransverseAspect.e = this.e;
        cylindricalEqualAreaTransverseAspect.g = this.g;
        cylindricalEqualAreaTransverseAspect.b = this.b;
        cylindricalEqualAreaTransverseAspect.a = this.a;
        try {
            cylindricalEqualAreaTransverseAspect.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return cylindricalEqualAreaTransverseAspect;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new CylindricalEqualAreaTransverseAspect(unit, unit2, stringArray, n2, this.getSchema());
    }

    private void a() {
        this.d = (Double)this.getValues()[2];
        this.e = (Double)this.getValues()[3];
        this.g = (Double)this.getValues()[4];
        this.b = (Double)this.getValues()[5];
        this.a = (Double)this.getValues()[6];
        return;
    }

    public CylindricalEqualAreaTransverseAspect(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public CylindricalEqualAreaTransverseAspect(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    public CylindricalEqualAreaTransverseAspect(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5, double d6) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.e = d3;
        this.d = d2;
        this.b = d5;
        this.a = d6;
        this.g = d4;
        this.init();
    }

    CylindricalEqualAreaTransverseAspect() {
    }
}

