/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodesyMath;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class CylindricalEqualAreaNormalAspect
extends GenericProjection {
    private double e;
    private double f;
    private double g;
    private double h;
    private double a;
    private double b;
    private double c;
    private double d;

    public void fromGeographic(Point3D point3D) throws CalculationException {
        if (this._ellipsoid.isSphere()) {
            point3D.x = this._ellipsoid.getRadius() * Utilities.longitude180(point3D.x - this.c) * this.e + this.b;
            point3D.y = this._ellipsoid.getRadius() * Math.sin(point3D.y) / this.e + this.a;
        } else {
            double d2 = this._ellipsoid.calcQ(point3D.y);
            point3D.x = this._ellipsoid.semiMajor() * this.e * Utilities.longitude180(point3D.x - this.c) + this.b;
            point3D.y = this._ellipsoid.semiMajor() * d2 / (2.0 * this.e) + this.a;
        }
        return;
    }

    private double a(double d2) {
        double d3 = Math.sin(d2);
        double d4 = d3 * this._ellipsoid.eccentricity();
        return (1.0 - this._ellipsoid.eccentricitySquared()) * (d3 / (1.0 - d4 * d4) - 1.0 / (2.0 * this._ellipsoid.eccentricity()) * Math.log((1.0 - d4) / (1.0 + d4)));
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        point3D.x -= this.b;
        point3D.y -= this.a;
        if (this._ellipsoid.isSphere()) {
            point3D.y = Math.asin(point3D.y / this._ellipsoid.getRadius() * this.e);
            point3D.x = this.c + point3D.x / (this._ellipsoid.getRadius() * this.e);
        } else {
            double d2 = this.a(1.5707963267948966);
            double d3 = Math.asin(2.0 * point3D.y * this.e / (this._ellipsoid.semiMajor() * d2));
            point3D.y = d3 + GeodesyMath.evenSineSeries(d3, this.h, this.g, this.f);
            point3D.x = this.c + point3D.x / (this._ellipsoid.semiMajor() * this.e);
        }
        return;
    }

    public void init() throws ValidationException {
        if (this._ellipsoid == null) {
            return;
        }
        this.makeHorizon(this.c, -1.5707963267948966, 1.5707963267948966);
        if (this._ellipsoid.isSphere()) {
            this.e = Math.cos(this.d);
        } else {
            double d2 = this._ellipsoid.eccentricity();
            double d3 = this._ellipsoid.eccentricitySquared();
            double d4 = d3 * d3;
            double d5 = d4 * d3;
            double d6 = d2 * Math.sin(this.d);
            this.e = Math.cos(this.d) / Math.sqrt(1.0 - d6 * d6);
            this.h = d3 / 3.0 + 31.0 * d4 / 180.0 + 517.0 * d5 / 5040.0;
            this.g = 23.0 * d4 / 360.0 + 251.0 * d5 / 3780.0;
            this.f = 761.0 * d5 / 45360.0;
        }
        return;
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new CylindricalEqualAreaNormalAspect(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        CylindricalEqualAreaNormalAspect cylindricalEqualAreaNormalAspect = null;
        cylindricalEqualAreaNormalAspect = (CylindricalEqualAreaNormalAspect)super.clone();
        cylindricalEqualAreaNormalAspect.c = this.c;
        cylindricalEqualAreaNormalAspect.d = this.d;
        cylindricalEqualAreaNormalAspect.b = this.b;
        cylindricalEqualAreaNormalAspect.a = this.a;
        try {
            cylindricalEqualAreaNormalAspect.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return cylindricalEqualAreaNormalAspect;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new CylindricalEqualAreaNormalAspect(unit, unit2, stringArray, n2, this.getSchema());
    }

    private void a() {
        this.c = (Double)this.getValues()[2];
        this.d = (Double)this.getValues()[3];
        this.b = (Double)this.getValues()[4];
        this.a = (Double)this.getValues()[5];
        return;
    }

    public CylindricalEqualAreaNormalAspect(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public CylindricalEqualAreaNormalAspect(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    public CylindricalEqualAreaNormalAspect(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.d = d3;
        this.c = d2;
        this.b = d4;
        this.a = d5;
        this.init();
    }

    CylindricalEqualAreaNormalAspect() {
    }
}

