/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class Cassini
extends GenericProjection {
    private double e;
    private double a;
    private double b;
    private double c;
    private double d;

    public void fromGeographic(Point3D point3D) throws CalculationException {
        if (this._ellipsoid.isSphere()) {
            double d2 = Utilities.angle180(point3D.x - this.c);
            double d3 = Math.cos(point3D.y) * Math.sin(d2);
            point3D.x = this.b + this._ellipsoid.getRadius() * Math.asin(d3);
            point3D.y = this.a + this._ellipsoid.getRadius() * (Math.atan(Math.tan(point3D.y) / Math.cos(d2)) - this.d);
        } else {
            double d4 = this._ellipsoid.radiusOfCurvatureN(point3D.y);
            double d5 = Math.tan(point3D.y);
            double d6 = d5 * d5;
            double d7 = Math.cos(point3D.y);
            double d8 = Utilities.angle180(point3D.x - this.c) * d7;
            double d9 = this._ellipsoid.eccentricitySquared() * d7 * d7 / (1.0 - this._ellipsoid.eccentricitySquared());
            double d10 = this._ellipsoid.meridianDistance(point3D.y);
            double d11 = d8 * d8;
            double d12 = d11 * d8;
            double d13 = d11 * d11;
            double d14 = d12 * d11;
            point3D.x = d4 * (d8 - d6 * d12 / 6.0 - (8.0 - d6 + 8.0 * d9) * d6 * d14 / 120.0);
            point3D.y = d10 - this.e + d4 * d5 * (d11 / 2.0 + (5.0 - d6 + 6.0 * d9) * d13 / 24.0);
        }
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        point3D.x -= this.b;
        point3D.y -= this.a;
        if (this._ellipsoid.isSphere()) {
            double d2 = point3D.x / this._ellipsoid.getRadius();
            double d3 = point3D.y / this._ellipsoid.getRadius() + this.d;
            point3D.y = Math.asin(Math.sin(d3) * Math.cos(d2));
            point3D.x = this.c + Math.atan(Math.tan(d2) / Math.cos(d3));
        } else {
            double d4 = this.e + point3D.y;
            double d5 = this._ellipsoid.meridianDistanceToRectifying(d4);
            double d6 = this._ellipsoid.rectifyingToLatitude(d5);
            double d7 = this._ellipsoid.radiusOfCurvatureR(d6);
            double d8 = this._ellipsoid.radiusOfCurvatureN(d6);
            double d9 = Math.tan(d6);
            double d10 = d9 * d9;
            double d11 = point3D.x / d8;
            double d12 = d11 * d11;
            double d13 = d12 * d11;
            double d14 = d12 * d12;
            double d15 = d12 * d13;
            point3D.y = d6 - d8 * d9 / d7 * (d12 / 2.0 - (1.0 + 3.0 * d10) * d14 / 24.0);
            point3D.x = this.c + (d11 - d10 * d13 / 3.0 + (1.0 + 3.0 * d10) * d10 * d15 / 15.0) / Math.cos(d6);
        }
        return;
    }

    public void init() throws ValidationException {
        if (this._ellipsoid == null) {
            return;
        }
        this.makeHorizon(this.c - 1.5707963267948966, this.c + 1.5707963267948966, -1.5707963267948966, 1.5707963267948966);
        this.e = this._ellipsoid.meridianDistance(this.d);
        return;
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new Cassini(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        Cassini cassini = null;
        cassini = (Cassini)super.clone();
        cassini.c = this.c;
        cassini.d = this.d;
        cassini.b = this.b;
        cassini.a = this.a;
        try {
            cassini.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return cassini;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new Cassini(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this.c);
        this.setValue(3, this.d);
        this.setValue(4, this.b);
        this.setValue(5, this.a);
        return;
    }

    private void a() {
        this.c = this.getValue(2);
        this.d = this.getValue(3);
        this.b = this.getValue(4);
        this.a = this.getValue(5);
        return;
    }

    public Cassini(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public Cassini(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    public Cassini(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.d = d3;
        this.c = d2;
        this.b = d4;
        this.a = d5;
        this.init();
    }

    Cassini() {
    }
}

