/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.BaseDatumTransformation;
import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;

public class BursaWolf
extends BaseDatumTransformation {
    private double d;
    private double e;
    private double a;
    private double b;
    private double c;
    private double f;
    private double g;
    private double h;

    public void inverse(Point3D point3D) throws CalculationException {
        double d2;
        double d3;
        double d4 = point3D.x;
        double d5 = point3D.y;
        double d6 = point3D.z;
        int n2 = 0;
        do {
            double d7 = point3D.x;
            double d8 = point3D.y;
            double d9 = point3D.z;
            this.forward(point3D);
            d3 = point3D.x - d4;
            d2 = point3D.y - d5;
            double d10 = point3D.z - d6;
            point3D.x = d7 - d3;
            point3D.y = d8 - d2;
            point3D.z = d9 - d10;
        } while (n2 < 50 && Math.abs(d3) > 1.0E-12 && Math.abs(d2) > 1.0E-12 && Math.abs(d2) > 1.0E-12);
        return;
    }

    public void forward(Point3D point3D) throws CalculationException {
        double d2 = this.h + this.d * (point3D.x - point3D.y * this.a + point3D.z * this.b);
        double d3 = this.g + this.d * (point3D.x * this.a + point3D.y - point3D.z * this.c);
        double d4 = this.f + this.d * (-point3D.x * this.b + point3D.y * this.c + point3D.z);
        point3D.x = d2;
        point3D.y = d3;
        point3D.z = d4;
        return;
    }

    public String getPEString() {
        return "METHOD[\"Coordinate_Frame\"], PARAMETER[\"X_Axis_Translation\"," + this.h + "], PARAMETER[\"Y_Axis_Translation\"," + this.g + "], PARAMETER[\"Z_Axis_Translation\"," + this.f + "], PARAMETER[\"X_Axis_Rotation\"," + -this.c + "], PARAMETER[\"Y_Axis_Rotation\"," + -this.b + "], PARAMETER[\"Z_Axis_Rotation\"," + -this.a + "], PARAMETER[\"Scale_Difference\"," + this.e + "]";
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new BursaWolf(geodeticRow, n2);
    }

    public Object clone() {
        BursaWolf bursaWolf = null;
        bursaWolf = (BursaWolf)super.clone();
        bursaWolf.h = this.h;
        bursaWolf.g = this.g;
        bursaWolf.f = this.f;
        bursaWolf.c = this.c;
        bursaWolf.b = this.b;
        bursaWolf.a = this.a;
        bursaWolf.e = this.e;
        bursaWolf.d = this.d;
        return bursaWolf;
    }

    public BursaWolf(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        if (geodeticRow.getLength() <= n2 + 6) {
            throw new InvalidRowDataException(geodeticRow);
        }
        try {
            this.h = Double.parseDouble(geodeticRow.getColumn(0 + n2));
            this.g = Double.parseDouble(geodeticRow.getColumn(1 + n2));
            this.f = Double.parseDouble(geodeticRow.getColumn(2 + n2));
            this.c = Double.parseDouble(geodeticRow.getColumn(3 + n2)) * 4.84813681109536E-6;
            this.b = Double.parseDouble(geodeticRow.getColumn(4 + n2)) * 4.84813681109536E-6;
            this.a = Double.parseDouble(geodeticRow.getColumn(5 + n2)) * 4.84813681109536E-6;
            this.e = Double.parseDouble(geodeticRow.getColumn(6 + n2));
        }
        catch (Exception exception) {
            throw new InvalidRowDataException(geodeticRow);
        }
        this.d = this.e * 1.0E-6 + 1.0;
    }

    BursaWolf() {
    }
}

