/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;
import com.esri.mo.cs.geod.ValidationMessageException;
import com.esri.mo.util.Resource;

public class Bonne
extends GenericProjection {
    private double e;
    private double f;
    private double g;
    private double a;
    private double b;
    private double c;
    private double d;

    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2 = Utilities.longitude180(point3D.x - this.c);
        if (this._ellipsoid.isSphere()) {
            double d3 = this._ellipsoid.getRadius() * (this.e + this.d - point3D.y);
            if (Math.abs(d3) < 1.0E-12) {
                point3D.x = this.b;
                point3D.y = this.a;
            } else {
                double d4 = this._ellipsoid.getRadius() * d2 * Math.cos(point3D.y) / d3;
                point3D.x = this.b + d3 * Math.sin(d4);
                point3D.y = this.a + this._ellipsoid.getRadius() * this.e - d3 * Math.cos(d4);
            }
        } else {
            double d5 = this.f + this.g - this._ellipsoid.meridianDistance(point3D.y);
            if (Math.abs(d5) < 1.0E-12) {
                point3D.x = this.b;
                point3D.y = this.a;
            } else {
                double d6 = this.a(point3D.y) * d2 / d5;
                point3D.x = this.b + d5 * Math.sin(d6);
                point3D.y = this.a + this.f - d5 * Math.cos(d6);
            }
        }
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        point3D.x -= this.b;
        point3D.y -= this.a;
        if (this._ellipsoid.isSphere()) {
            double d2 = this._ellipsoid.getRadius() * this.e - point3D.y;
            double d3 = Utilities.signum(this.d) * Math.sqrt(point3D.x * point3D.x + d2 * d2);
            point3D.y = this.e + this.d - d3 / this._ellipsoid.getRadius();
            point3D.x = Utilities.angleIsZero(point3D.y) ? this.c : this.c + d3 * Math.atan(point3D.x / d2) / (this._ellipsoid.getRadius() * Math.cos(point3D.y));
        } else {
            double d4 = this.f - point3D.y;
            double d5 = Utilities.signum(this.d) * Math.sqrt(point3D.x * point3D.x + d4 * d4);
            double d6 = this.f + this.g - d5;
            double d7 = this._ellipsoid.meridianDistanceToRectifying(d6);
            double d8 = this._ellipsoid.rectifyingToLatitude(d7);
            point3D.x = this.c + d5 * Math.atan(point3D.x / (this.f - point3D.y)) / this.a(d8);
            point3D.y = d8;
        }
        return;
    }

    private double a(double d2) {
        double d3 = Math.sin(d2);
        return this._ellipsoid.semiMajor() * Math.cos(d2) / Math.sqrt(1.0 - this._ellipsoid.eccentricitySquared() * d3 * d3);
    }

    public void init() throws ValidationException {
        if (this._ellipsoid == null) {
            return;
        }
        if (Utilities.angleIsZero(this.d)) {
            throw new ValidationMessageException(Resource.formatMessage0("BStandardParallelOnEquator"));
        }
        this.makeHorizon(this.c, -1.5707963267948966, 1.5707963267948966);
        if (this._ellipsoid.isSphere()) {
            this.e = Utilities.cotan(this.d);
        } else {
            this.g = this._ellipsoid.meridianDistance(this.d);
            this.f = this.a(this.d) / Math.sin(this.d);
        }
        return;
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new Bonne(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        Bonne bonne = null;
        bonne = (Bonne)super.clone();
        bonne.c = this.c;
        bonne.d = this.d;
        bonne.b = this.b;
        bonne.a = this.a;
        try {
            bonne.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return bonne;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new Bonne(unit, unit2, stringArray, n2, this.getSchema());
    }

    public Bonne(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this.c);
        this.setValue(3, this.d);
        this.setValue(4, this.b);
        this.setValue(5, this.a);
        return;
    }

    private void a() {
        this.c = this.getValue(2);
        this.d = this.getValue(3);
        this.b = this.getValue(4);
        this.a = this.getValue(5);
        return;
    }

    public Bonne(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    public Bonne(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.d = d3;
        this.c = d2;
        this.b = d4;
        this.a = d5;
        this.init();
    }

    Bonne() {
    }
}

