/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Datum;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GeodeticDatabase;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.GeodeticTable;
import com.esri.mo.cs.geod.Horizon;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.NamedObject;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.PrimeMeridian;
import com.esri.mo.cs.geod.Projection;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;
import java.util.Iterator;

public abstract class BaseProjection
implements NamedObject,
Projection {
    private ProjectionSchema a;
    protected Unit _linearUnit;
    protected Unit _angleUnit;
    protected Ellipsoid _ellipsoid;

    public abstract Datum getDatum();

    public abstract PrimeMeridian getPrimeMeridian();

    public abstract void toWGS84Geographic(Point3D var1) throws CalculationException;

    public abstract void fromWGS84Geographic(Point3D var1) throws CalculationException;

    public abstract String getPEDatumString();

    public abstract String getPECoordSysString();

    public abstract boolean hasDatumTransformation();

    public abstract Horizon getHorizon();

    public abstract String getPEString();

    public abstract GeodeticObject createObject(GeodeticRow var1, int var2) throws InvalidRowDataException;

    public abstract GeodeticTable getTable();

    public abstract Object getParameterValue(int var1);

    public abstract boolean hasEllipsoidalSolution();

    public abstract boolean hasSphereSolution();

    public abstract GeodeticObject createObject(Unit var1, Unit var2, String[] var3, int var4) throws InvalidDataException;

    protected double calcT(double d2) {
        double d3 = this._ellipsoid.eccentricity() * Math.sin(d2);
        double d4 = 0.7853981633974483 - d2 / 2.0;
        if (Utilities.angleIsHalfPi(Math.abs(d4))) {
            return 0.0;
        }
        return Math.tan(d4) / Math.pow((1.0 - d3) / (1.0 + d3), this._ellipsoid.eccentricity() / 2.0);
    }

    public void init() throws ValidationException {
    }

    protected double getValue(GeodeticRow geodeticRow, int n2, int n3) throws InvalidDataException {
        return this.a.convertDouble(geodeticRow.getColumn(n2 + n3), n3, this._linearUnit, this._angleUnit);
    }

    protected void needColumns(GeodeticRow geodeticRow, int n2, int n3) throws InvalidRowDataException {
        if (geodeticRow.getLength() < n2 + n3) {
            throw new InvalidRowDataException(geodeticRow);
        }
        return;
    }

    public void setUnit(Unit unit) {
        this._linearUnit = unit;
    }

    public Unit getAngularUnit() {
        return this._angleUnit;
    }

    public Unit getUnit() {
        return this._linearUnit;
    }

    public Ellipsoid getEllipsoid() {
        return this._ellipsoid;
    }

    public void setEllipsoid(Ellipsoid ellipsoid) {
        this._ellipsoid = ellipsoid;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
    }

    public void fromGeographic(Point3D point3D) throws CalculationException {
    }

    public Object clone() {
        BaseProjection baseProjection = null;
        try {
            baseProjection = (BaseProjection)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        this._ellipsoid = (Ellipsoid)this._ellipsoid.clone();
        return baseProjection;
    }

    protected ProjectionSchema getSchema() {
        if (this.a == null) {
            GeodeticTable geodeticTable = GeodeticDatabase.getDatabase().getProjectionSchemaTable();
            Iterator iterator = geodeticTable.rowIterator();
            String string = this.getClass().getName();
            while (iterator.hasNext()) {
                GeodeticRow geodeticRow = (GeodeticRow)iterator.next();
                if (!string.endsWith(geodeticRow.getColumn(4))) continue;
                try {
                    this.a = new ProjectionSchema(geodeticRow);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
        }
        return this.a;
    }

    public BaseProjection(ProjectionSchema projectionSchema) {
        this.a = projectionSchema;
    }

    public String getLongDescription() {
        return this.a.getLongDescription();
    }

    public String getDescription() {
        return this.a.getDescription();
    }

    public String getName() {
        return this.a.getName();
    }

    public boolean isLatitudeLongitude() {
        return false;
    }

    public ProjectionSchema getFactory() {
        return this.a;
    }

    public void setFactory(ProjectionSchema projectionSchema) {
        this.a = projectionSchema;
    }

    BaseProjection() {
    }
}

