/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.GeodeticTable;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.NamedObject;

public abstract class BaseNamedGeodeticObject
implements Cloneable,
GeodeticObject,
NamedObject {
    protected GeodeticTable _table;
    protected String _longDescription;
    protected String _description;
    protected String _name;

    public abstract GeodeticObject createObject(GeodeticRow var1, int var2) throws InvalidRowDataException;

    public GeodeticTable getTable() {
        return this._table;
    }

    public BaseNamedGeodeticObject() {
        this._table = null;
    }

    public BaseNamedGeodeticObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        this._table = geodeticRow.getTable();
        if (geodeticRow.getLength() < 3) {
            throw new InvalidRowDataException(geodeticRow);
        }
        this._name = geodeticRow.getColumn(n2);
        if (this._name == null || this._name.length() < 1) {
            throw new InvalidRowDataException(geodeticRow);
        }
        this._description = geodeticRow.getColumn(1 + n2);
        if (this._description == null) {
            throw new InvalidRowDataException(geodeticRow);
        }
        this._longDescription = geodeticRow.getColumn(2 + n2);
        if (this._longDescription == null) {
            throw new InvalidRowDataException(geodeticRow);
        }
    }

    public String getLongDescription() {
        return this._longDescription;
    }

    public String getDescription() {
        return this._description;
    }

    public String toString() {
        return this._description;
    }

    public String getName() {
        return this._name;
    }

    public Object clone() {
        BaseNamedGeodeticObject baseNamedGeodeticObject = null;
        try {
            baseNamedGeodeticObject = (BaseNamedGeodeticObject)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        if (this._name != null) {
            baseNamedGeodeticObject._name = this._name.toString();
        }
        if (this._description != null) {
            baseNamedGeodeticObject._description = this._description.toString();
        }
        if (this._longDescription != null) {
            baseNamedGeodeticObject._longDescription = this._longDescription.toString();
        }
        baseNamedGeodeticObject._table = this._table;
        return baseNamedGeodeticObject;
    }
}

