/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.DatumTransformation;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GeodeticDatabase;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.GeodeticTable;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.VariableSchema;

public abstract class BaseDatumTransformation
implements DatumTransformation {
    protected VariableSchema _schema;
    protected Ellipsoid _targetEllipsoid;
    protected Ellipsoid _sourceEllipsoid;

    public abstract String getPEString();

    public abstract GeodeticObject createObject(GeodeticRow var1, int var2) throws InvalidRowDataException;

    public GeodeticTable getTable() {
        return GeodeticDatabase.getDatabase().getDatumTransformationSchemaTable();
    }

    public String getLongDescription() {
        return this._schema.getLongDescription();
    }

    public String getDescription() {
        return this._schema.getDescription();
    }

    public String getName() {
        return this._schema.getName();
    }

    public void setFactory(VariableSchema variableSchema) {
        this._schema = variableSchema;
    }

    public void setTargetEllipsoid(Ellipsoid ellipsoid) {
        this._targetEllipsoid = ellipsoid;
    }

    public void setSourceEllipsoid(Ellipsoid ellipsoid) {
        this._sourceEllipsoid = ellipsoid;
    }

    public void inverse(Point3D point3D) throws CalculationException {
    }

    public void forward(Point3D point3D) throws CalculationException {
    }

    public Ellipsoid sourceEllipsoid() {
        return this._sourceEllipsoid;
    }

    public boolean hasDatumTransformation() {
        return true;
    }

    public Object clone() {
        BaseDatumTransformation baseDatumTransformation = null;
        try {
            baseDatumTransformation = (BaseDatumTransformation)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        baseDatumTransformation._sourceEllipsoid = (Ellipsoid)this._sourceEllipsoid.clone();
        baseDatumTransformation._targetEllipsoid = (Ellipsoid)this._targetEllipsoid.clone();
        return baseDatumTransformation;
    }

    public Ellipsoid targetEllipsoid() {
        return this._targetEllipsoid;
    }
}

