/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.AzimuthalEquidistantNorthPolarAspect;
import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.ValidationException;

public class AzimuthalEquidistantSouthPolarAspect
extends AzimuthalEquidistantNorthPolarAspect {
    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2 = point3D.x - this._lon0;
        double d3 = this._ellipsoid.isSphere() ? this._ellipsoid.getRadius() * (1.5707963267948966 + point3D.y) : this._ellipsoid.meridianDistanceToPole() + this._ellipsoid.meridianDistance(point3D.y);
        point3D.x = this._x0 + d3 * Math.sin(d2);
        point3D.y = this._y0 + d3 * Math.cos(d2);
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        point3D.y -= this._y0;
        point3D.x -= this._x0;
        double d2 = Math.sqrt(point3D.x * point3D.x + point3D.y * point3D.y);
        point3D.x = this._lon0 + Math.atan2(point3D.x, point3D.y);
        if (this._ellipsoid.isSphere()) {
            point3D.y = Math.asin(-Math.cos(d2 / this._ellipsoid.getRadius()));
        } else {
            double d3 = d2 - this._ellipsoid.meridianDistanceToPole();
            double d4 = this._ellipsoid.meridianDistanceToRectifying(d3);
            point3D.y = this._ellipsoid.rectifyingToLatitude(d4);
        }
        return;
    }

    public AzimuthalEquidistantSouthPolarAspect(Ellipsoid ellipsoid, double d2, double d3, double d4) throws ValidationException {
        super(ellipsoid, d2, d3, d4);
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new AzimuthalEquidistantSouthPolarAspect(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        AzimuthalEquidistantSouthPolarAspect azimuthalEquidistantSouthPolarAspect = null;
        azimuthalEquidistantSouthPolarAspect = (AzimuthalEquidistantSouthPolarAspect)super.clone();
        return azimuthalEquidistantSouthPolarAspect;
    }

    public void init() throws ValidationException {
        this.makeHorizon(this._lon0, -1.5707963267948966, 0.0);
        return;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new AzimuthalEquidistantSouthPolarAspect(unit, unit2, stringArray, n2, this.getSchema());
    }

    public AzimuthalEquidistantSouthPolarAspect(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
    }

    public AzimuthalEquidistantSouthPolarAspect(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
    }

    AzimuthalEquidistantSouthPolarAspect() {
    }
}

