/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.ValidationException;

public class AzimuthalEquidistantNorthPolarAspect
extends GenericProjection {
    protected double _lon0;
    protected double _y0;
    protected double _x0;

    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2 = this._ellipsoid.isSphere() ? this._ellipsoid.getRadius() * (1.5707963267948966 - point3D.y) : this._ellipsoid.meridianDistanceToPole() - this._ellipsoid.meridianDistance(point3D.y);
        double d3 = point3D.x - this._lon0;
        point3D.x = this._x0 + d2 * Math.sin(d3);
        point3D.y = this._y0 + -d2 * Math.cos(d3);
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        point3D.y -= this._y0;
        point3D.x -= this._x0;
        double d2 = Math.sqrt(point3D.x * point3D.x + point3D.y * point3D.y);
        point3D.x = this._lon0 + Math.atan2(point3D.x, -point3D.y);
        if (this._ellipsoid.isSphere()) {
            point3D.y = Math.asin(Math.cos(d2 / this._ellipsoid.getRadius()));
        } else {
            double d3 = this._ellipsoid.meridianDistanceToPole() - d2;
            double d4 = this._ellipsoid.meridianDistanceToRectifying(d3);
            point3D.y = this._ellipsoid.rectifyingToLatitude(d4);
        }
        return;
    }

    public void init() throws ValidationException {
        this.makeHorizon(this._lon0, 0.0, 1.5707963267948966);
        return;
    }

    public AzimuthalEquidistantNorthPolarAspect(Ellipsoid ellipsoid, double d2, double d3, double d4) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this._x0 = d3;
        this._y0 = d4;
        this._lon0 = d2;
        this.init();
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new AzimuthalEquidistantNorthPolarAspect(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        AzimuthalEquidistantNorthPolarAspect azimuthalEquidistantNorthPolarAspect = null;
        azimuthalEquidistantNorthPolarAspect = (AzimuthalEquidistantNorthPolarAspect)super.clone();
        azimuthalEquidistantNorthPolarAspect._lon0 = this._lon0;
        azimuthalEquidistantNorthPolarAspect._y0 = this._y0;
        azimuthalEquidistantNorthPolarAspect._x0 = this._x0;
        try {
            azimuthalEquidistantNorthPolarAspect.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return azimuthalEquidistantNorthPolarAspect;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new AzimuthalEquidistantNorthPolarAspect(unit, unit2, stringArray, n2, this.getSchema());
    }

    public AzimuthalEquidistantNorthPolarAspect(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this._lon0);
        this.setValue(3, this._x0);
        this.setValue(4, this._y0);
        return;
    }

    private void a() {
        this._lon0 = this.getValue(2);
        this._x0 = this.getValue(3);
        this._y0 = this.getValue(4);
        return;
    }

    public AzimuthalEquidistantNorthPolarAspect(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    AzimuthalEquidistantNorthPolarAspect() {
    }
}

