/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.AzimuthalEquidistantGuamObliqueAspect;
import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class AzimuthalEquidistantMicronesiaObliqueAspect
extends AzimuthalEquidistantGuamObliqueAspect {
    private double b;
    private double c;
    private double d;
    private double a;
    private double e;
    private double f;

    public void fromGeographic(Point3D point3D) throws CalculationException {
        if (this._ellipsoid.isSphere()) {
            this.sphereFromGeographic(point3D);
            return;
        }
        double d2 = this._ellipsoid.radiusOfCurvatureN(point3D.y);
        double d3 = Math.atan(this.b * Math.tan(point3D.y) + this.d / (d2 * Math.cos(point3D.y)));
        double d4 = point3D.x - this._lon0;
        double d5 = Math.atan2(Math.sin(d4), this.e * Math.tan(d3) - this.a * Math.cos(d4));
        double d6 = Math.sin(d5);
        double d7 = Math.cos(d5);
        double d8 = Math.abs(d6) < 1.0E-14 ? Utilities.signum(d7) * Math.asin(this.e * Math.sin(d3) - this.a * Math.cos(d3)) : Math.asin(Math.sin(d4) * Math.cos(d3) / d6);
        double d9 = this.a * this.c;
        double d10 = this.e * this.c * d7;
        double d11 = d10 * d10;
        double d12 = d8 * d8;
        double d13 = d12 * d8;
        double d14 = d12 * d12;
        double d15 = d13 * d12;
        double d16 = this.f * d8 * (1.0 - d12 * d11 * (1.0 - d11) / 6.0 + d13 / 8.0 * d9 * d10 * (1.0 - 2.0 * d11) + d14 / 120.0 * (d11 * (4.0 - 7.0 * d11) - 3.0 * d9 * d9 * (1.0 - 7.0 * d11)) - d15 / 48.0 * d9 * d10);
        point3D.x = d16 * d6 + this._x0;
        point3D.y = d16 * d7 + this._y0;
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        if (this._ellipsoid.isSphere()) {
            this.sphereToGeographic(point3D);
            return;
        }
        point3D.y -= this._y0;
        point3D.x -= this._x0;
        double d2 = Math.sqrt(point3D.x * point3D.x + point3D.y * point3D.y);
        double d3 = Math.atan2(point3D.x, point3D.y);
        double d4 = Math.cos(d3);
        double d5 = Math.sin(d3);
        double d6 = -this._ellipsoid.eccentricitySquared() * this.e * this.e * d4 * d4 / this.b;
        double d7 = 3.0 * this._ellipsoid.eccentricitySquared() * (1.0 - d6) * this.a * this.e * d4 / this.b;
        double d8 = d2 / this.f;
        double d9 = d8 * d8;
        double d10 = d9 * d8;
        double d11 = d9 * d9;
        double d12 = d8 - d6 * (1.0 + d6) * d10 / 6.0 - d7 * (1.0 + 3.0 * d6) * d11 / 24.0;
        double d13 = Math.sin(d12);
        double d14 = d12 * d12;
        double d15 = d14 * d12;
        double d16 = 1.0 - d6 * d14 / 2.0 - d7 * d15 / 6.0;
        double d17 = Math.asin(this.a * Math.cos(d12) + this.e * d13 * d4);
        point3D.x = this._lon0 + Math.asin(d5 * d13 / Math.cos(d17));
        point3D.y = Math.atan((1.0 - this._ellipsoid.eccentricitySquared() * d16 * this.a / Math.sin(d17)) * Math.tan(d17) / this.b);
        return;
    }

    public void init() throws ValidationException {
        super.init();
        if (this._ellipsoid == null) {
            return;
        }
        this.makeHorizon(this._lon0, -1.5707963267948966, 1.5707963267948966);
        this.f = this._ellipsoid.radiusOfCurvatureN(this._lat1);
        this.e = Math.cos(this._lat1);
        this.a = Math.sin(this._lat1);
        this.d = this._ellipsoid.eccentricitySquared() * this.f * this.a;
        this.c = this._ellipsoid.eccentricity() / Math.sqrt(1.0 - this._ellipsoid.eccentricitySquared());
        this.b = 1.0 - this._ellipsoid.eccentricitySquared();
        return;
    }

    public AzimuthalEquidistantMicronesiaObliqueAspect(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5) throws ValidationException {
        super(ellipsoid, d2, d3, d4, d5);
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new AzimuthalEquidistantMicronesiaObliqueAspect(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        AzimuthalEquidistantMicronesiaObliqueAspect azimuthalEquidistantMicronesiaObliqueAspect = null;
        azimuthalEquidistantMicronesiaObliqueAspect = (AzimuthalEquidistantMicronesiaObliqueAspect)super.clone();
        return azimuthalEquidistantMicronesiaObliqueAspect;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new AzimuthalEquidistantMicronesiaObliqueAspect(unit, unit2, stringArray, n2, this.getSchema());
    }

    public AzimuthalEquidistantMicronesiaObliqueAspect(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
    }

    public AzimuthalEquidistantMicronesiaObliqueAspect(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
    }

    AzimuthalEquidistantMicronesiaObliqueAspect() {
    }
}

