/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class AzimuthalEquidistantGuamObliqueAspect
extends GenericProjection {
    protected double _M1;
    protected double _lat1;
    protected double _lon0;
    protected double _y0;
    protected double _x0;

    public void fromGeographic(Point3D point3D) throws CalculationException {
        if (this._ellipsoid.isSphere()) {
            this.sphereFromGeographic(point3D);
            return;
        }
        double d2 = Math.cos(point3D.y);
        double d3 = Math.sin(point3D.y);
        double d4 = Math.sqrt(1.0 - this._ellipsoid.eccentricitySquared() * d3 * d3);
        point3D.x = this._ellipsoid.semiMajor() * (point3D.x - this._lon0) * d2 / d4;
        if (d2 > 1.0E-16) {
            double d5 = d3 / d2;
            point3D.y = this._y0 + this._ellipsoid.meridianDistance(point3D.y) - this._M1 + point3D.x * point3D.x * d5 * d4 / (2.0 * this._ellipsoid.semiMajor());
        } else {
            point3D.y = 1.0E30 + this._y0;
        }
        point3D.x += this._x0;
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        if (this._ellipsoid.isSphere()) {
            this.sphereToGeographic(point3D);
            return;
        }
        point3D.y -= this._y0;
        point3D.x -= this._x0;
        double d9 = this._lat1;
        do {
            d2 = d9;
            d4 = Math.cos(d9);
            if (!(Math.abs(d4) < 1.0E-14)) continue;
            point3D.y = d9;
            point3D.x = this._lon0;
            return;
        } while (Math.abs((d9 = this._ellipsoid.rectifyingToLatitude(d8 = this._ellipsoid.meridianDistanceToRectifying(d7 = this._M1 + point3D.y - point3D.x * point3D.x * (d6 = (d5 = Math.sin(d9)) / d4) * (d3 = Math.sqrt(1.0 - this._ellipsoid.eccentricitySquared() * d5 * d5)) / (2.0 * this._ellipsoid.semiMajor())))) - d2) > 1.0E-12);
        point3D.x = this._lon0 + point3D.x * d3 / (d4 * this._ellipsoid.semiMajor());
        point3D.y = d9;
        return;
    }

    protected void sphereFromGeographic(Point3D point3D) throws CalculationException {
        double d2 = Math.sin(this._lat1);
        double d3 = Math.sin(point3D.y);
        double d4 = Math.cos(this._lat1);
        double d5 = Math.cos(point3D.y);
        double d6 = Utilities.longitude180(point3D.x - this._lon0);
        double d7 = Math.cos(d6);
        double d8 = d2 * d3 + d4 * d5 * d7;
        double d9 = Math.acos(d8);
        if (Utilities.angleIsZero(d9)) {
            point3D.x = this._x0;
            point3D.y = this._y0;
            return;
        }
        double d10 = d9 / Math.sin(d9);
        point3D.x = this._ellipsoid.getRadius() * d10 * d5 * Math.sin(d6);
        point3D.y = this._ellipsoid.getRadius() * d10 * (d4 * d3 - d2 * d5 * d7);
        return;
    }

    protected void sphereToGeographic(Point3D point3D) throws CalculationException {
        point3D.y -= this._y0;
        point3D.x -= this._x0;
        double d2 = Math.sqrt(point3D.x * point3D.x + point3D.y * point3D.y);
        double d3 = d2 / this._ellipsoid.getRadius();
        double d4 = Math.cos(d3);
        double d5 = Math.sin(d3);
        double d6 = Math.cos(this._lat1);
        double d7 = Math.sin(this._lat1);
        point3D.x = Utilities.angle180(this._lon0 + Math.atan2(point3D.x * d5, d2 * d6 * d4 - point3D.y * d7 * d5));
        point3D.y = Math.asin(d4 * d7 + point3D.y * d5 * d6 / d2);
        return;
    }

    public void init() throws ValidationException {
        if (this._ellipsoid == null) {
            return;
        }
        if (!this._ellipsoid.isSphere()) {
            this._M1 = this._ellipsoid.meridianDistance(this._lat1);
        }
        this.makeHorizon(this._lon0, -1.5707963267948966, 1.5707963267948966);
        return;
    }

    public AzimuthalEquidistantGuamObliqueAspect(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this._x0 = d4;
        this._y0 = d5;
        this._lon0 = d2;
        this._lat1 = d3;
        this.init();
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new AzimuthalEquidistantGuamObliqueAspect(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        AzimuthalEquidistantGuamObliqueAspect azimuthalEquidistantGuamObliqueAspect = null;
        azimuthalEquidistantGuamObliqueAspect = (AzimuthalEquidistantGuamObliqueAspect)super.clone();
        azimuthalEquidistantGuamObliqueAspect._lon0 = this._lon0;
        azimuthalEquidistantGuamObliqueAspect._lat1 = this._lat1;
        azimuthalEquidistantGuamObliqueAspect._y0 = this._y0;
        azimuthalEquidistantGuamObliqueAspect._x0 = this._x0;
        try {
            azimuthalEquidistantGuamObliqueAspect.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return azimuthalEquidistantGuamObliqueAspect;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new AzimuthalEquidistantGuamObliqueAspect(unit, unit2, stringArray, n2, this.getSchema());
    }

    public AzimuthalEquidistantGuamObliqueAspect(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this._lon0);
        this.setValue(3, this._lat1);
        this.setValue(4, this._x0);
        this.setValue(5, this._y0);
        return;
    }

    private void a() {
        this._lon0 = this.getValue(2);
        this._lat1 = this.getValue(3);
        this._x0 = this.getValue(4);
        this._y0 = this.getValue(5);
        return;
    }

    public AzimuthalEquidistantGuamObliqueAspect(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    AzimuthalEquidistantGuamObliqueAspect() {
    }
}

