/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.AlbersEqualArea;
import com.esri.mo.cs.geod.AngularUnit;
import com.esri.mo.cs.geod.Datum;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeographicCoordinateSystem;
import com.esri.mo.cs.geod.Mercator;
import com.esri.mo.cs.geod.PolarStereographic;
import com.esri.mo.cs.geod.PrimeMeridian;
import com.esri.mo.cs.geod.ReferencedCoordinateSystem;
import com.esri.mo.cs.geod.ReferencedCoordinateSystemImpl;
import com.esri.mo.cs.geod.Robinson;
import com.esri.mo.cs.geod.TransverseMercator;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;

public class AutoCoordSys {
    private static final int e = 6;
    private static final int c = 5;
    private static final int f = 4;
    private static final int a = 3;
    private static final int b = 2;
    private static final int d = 1;

    public static ReferencedCoordinateSystem getCoordSys(double d2, double d3, double d4, double d5) {
        GenericProjection genericProjection;
        String string;
        String string2;
        int n2 = 0;
        double d6 = d5 / 2.0;
        double d7 = d4 / 2.0;
        double d8 = d3 + d6;
        double d9 = d3 - d6;
        AngularUnit angularUnit = new AngularUnit("Decimal Degrees", " deg.", 3, Math.PI / 180);
        GeographicCoordinateSystem geographicCoordinateSystem = new GeographicCoordinateSystem(angularUnit, Datum.WGS84, PrimeMeridian.GREENWICH);
        n2 = d5 <= 90.0 ? (d3 > 80.0 ? 1 : (d3 < -80.0 ? 2 : (d4 < 30.0 && d8 < 80.0 && d9 > -80.0 ? 3 : (d9 * d8 > 0.0 ? 4 : (d9 > -70.0 && d8 < 70.0 ? 6 : 5))))) : (d4 > 350.0 || d5 > 120.0 ? 5 : (d9 * d8 > 0.0 ? 4 : (d9 > -70.0 && d8 < 70.0 ? 6 : 5)));
        switch (n2) {
            case 6: {
                string2 = "Mercator";
                string = "Mercator (Ellipsoid = WGS84)";
                break;
            }
            case 5: {
                string2 = "Robinson";
                string = "Robinson (Ellipsoid = WGS84)";
                break;
            }
            case 3: {
                string2 = "Transverse Mercator";
                string = "Transverse Mercator (Ellipsoid = WGS84)";
                break;
            }
            default: {
                string2 = "Albers Equal Area";
                string = "Albers Equal Area (Ellipsoid = WGS84)";
                break;
            }
            case 2: {
                string2 = "South Polar Stereographic";
                string = "South Polar Stereographic (Ellipsoid = WGS84)";
                break;
            }
            case 1: {
                string2 = "North Polar Stereographic";
                string = "North Polar Stereographic (Ellipsoid = WGS84)";
            }
        }
        String string3 = string2;
        try {
            switch (n2) {
                case 5: {
                    genericProjection = new Robinson(Ellipsoid.WGS84, Utilities.decimalDegreesToRadians(d2), 0.0, 0.0);
                    break;
                }
                default: {
                    if (d8 > 90.0) {
                        d8 = 90.0;
                    }
                    if (d9 < -90.0) {
                        d9 = -90.0;
                    }
                    double d10 = (d8 - d9) * 0.667 / 2.0;
                    genericProjection = new AlbersEqualArea(Ellipsoid.WGS84, Utilities.decimalDegreesToRadians(d2), Utilities.decimalDegreesToRadians(d3), Utilities.decimalDegreesToRadians(d3 - d10), Utilities.decimalDegreesToRadians(d3 + d10), 0.0, 0.0);
                    break;
                }
                case 6: {
                    genericProjection = new Mercator(Ellipsoid.WGS84, Utilities.decimalDegreesToRadians(d2), Utilities.decimalDegreesToRadians(0.0), 0.0, 0.0);
                    break;
                }
                case 3: {
                    genericProjection = new TransverseMercator(Ellipsoid.WGS84, Utilities.decimalDegreesToRadians(d2), Utilities.decimalDegreesToRadians(d3), 1.0, 0.0, 0.0);
                    break;
                }
                case 1: 
                case 2: {
                    genericProjection = new PolarStereographic(Ellipsoid.WGS84, Utilities.decimalDegreesToRadians(d2), Utilities.decimalDegreesToRadians(d3), 1.0, 0.0, 0.0);
                    break;
                }
            }
        }
        catch (ValidationException validationException) {
            validationException.printStackTrace();
            return null;
        }
        try {
            ReferencedCoordinateSystemImpl referencedCoordinateSystemImpl = new ReferencedCoordinateSystemImpl(geographicCoordinateSystem, genericProjection, string3, string2, string);
            return referencedCoordinateSystemImpl;
        }
        catch (ValidationException validationException) {
            validationException.printStackTrace();
            return null;
        }
    }
}

