/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.FactorBasedUnit;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Unit;

public class AngularUnit
extends FactorBasedUnit
implements Unit {
    public static final AngularUnit DECIMAL_DEGREES = new AngularUnit("Decimal Degrees", "deg.", 3, Math.PI / 180);

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new AngularUnit(geodeticRow, n2);
    }

    public AngularUnit(String string, String string2, int n2, double d2) {
        super(string, string2, n2, d2);
    }

    public AngularUnit(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(geodeticRow, n2);
        if (geodeticRow.getLength() < 7) {
            throw new InvalidRowDataException(geodeticRow);
        }
        try {
            this._suffix = geodeticRow.getColumn(4);
            this._toMKS = Double.parseDouble(geodeticRow.getColumn(5));
            this._precision = Integer.parseInt(geodeticRow.getColumn(6));
        }
        catch (Exception exception) {
            throw new InvalidRowDataException(geodeticRow);
        }
    }

    AngularUnit() {
    }
}

