/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.AngularField;
import com.esri.mo.cs.geod.BaseParameter;
import com.esri.mo.cs.geod.GeoDialogInfo;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Parameter;
import com.esri.mo.cs.geod.Unit;
import javax.swing.JComponent;

public class AngularParameter
extends BaseParameter
implements Parameter {
    public JComponent createComponent(GeoDialogInfo geoDialogInfo) throws InvalidDataException {
        AngularField angularField = new AngularField(0.0, geoDialogInfo);
        angularField.setRange(Math.PI * -2, Math.PI * 2);
        return angularField;
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new AngularParameter(geodeticRow, n2);
    }

    public double convertDouble(String string, Unit unit, Unit unit2) throws InvalidDataException {
        try {
            return unit.convertToMKS(string);
        }
        catch (Exception exception) {
            throw new InvalidDataException();
        }
    }

    public String convertFrom(Object object, Unit unit, Unit unit2) throws InvalidDataException {
        try {
            return unit.convertFromMKSToString((Double)object);
        }
        catch (Exception exception) {
            throw new InvalidDataException();
        }
    }

    public Object convert(String string, Unit unit, Unit unit2) throws InvalidDataException {
        try {
            return new Double(unit.convertToMKS(string));
        }
        catch (Exception exception) {
            throw new InvalidDataException();
        }
    }

    public AngularParameter(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(geodeticRow, n2);
    }

    AngularParameter() {
    }
}

