/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.FormattedDocument;
import com.esri.mo.cs.geod.GeoDialogInfo;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.NumericField;
import com.esri.mo.cs.geod.RangeValidationException;
import com.esri.mo.cs.geod.ValidationException;
import java.awt.Toolkit;
import java.text.NumberFormat;
import javax.swing.text.JTextComponent;

public class AngularField
extends NumericField {
    private GeoDialogInfo a;

    public double validation() throws RangeValidationException, InvalidDataException {
        double d2;
        try {
            d2 = this.a.getAngularUnit().convertToMKS(this.getText());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InvalidDataException();
        }
        if (d2 < this._minValue || d2 > this._maxValue) {
            throw new RangeValidationException();
        }
        return d2;
    }

    public void setValue(double d2) {
        if (this.a != null) {
            this.setText(this.a.getAngularUnit().convertFromMKSToString(d2));
        }
        return;
    }

    public double getValue() {
        double d2 = 0.0;
        try {
            if (this.getText().equals("-")) {
                return 0.0;
            }
            d2 = this.a.getAngularUnit().convertToMKS(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (ValidationException validationException) {
            Toolkit.getDefaultToolkit().beep();
        }
        return d2;
    }

    public AngularField(double d2, GeoDialogInfo geoDialogInfo) {
        super(d2, 0, NumberFormat.getInstance());
        this.a = geoDialogInfo;
        ((JTextComponent)this).setDocument(new FormattedDocument(NumberFormat.getInstance()));
        this.setValue(d2);
    }
}

