/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.cs.geod;

import com.esri.mo.cs.geod.CalculationException;
import com.esri.mo.cs.geod.Ellipsoid;
import com.esri.mo.cs.geod.GenericProjection;
import com.esri.mo.cs.geod.GeodeticObject;
import com.esri.mo.cs.geod.GeodeticRow;
import com.esri.mo.cs.geod.InvalidDataException;
import com.esri.mo.cs.geod.InvalidRowDataException;
import com.esri.mo.cs.geod.Point3D;
import com.esri.mo.cs.geod.ProjectionSchema;
import com.esri.mo.cs.geod.Unit;
import com.esri.mo.cs.geod.Utilities;
import com.esri.mo.cs.geod.ValidationException;
import com.esri.mo.cs.geod.ValidationMessageException;
import com.esri.mo.util.Resource;

public class AlbersEqualArea
extends GenericProjection {
    private double i;
    private double c;
    private double j;
    private double d;
    private double e;
    private double h;
    private double f;
    private double g;
    private double a;
    private double b;

    public void fromGeographic(Point3D point3D) throws CalculationException {
        double d2 = this._ellipsoid.isSphere() ? 2.0 * Math.sin(point3D.y) : this._ellipsoid.calcQ(point3D.y);
        double d3 = this._ellipsoid.semiMajor() * Math.sqrt(this.j - this.d * d2) / this.d;
        double d4 = this.d * Utilities.longitude180(point3D.x - this.e);
        point3D.x = d3 * Math.sin(d4) + this.b;
        point3D.y = this.a + this.c - d3 * Math.cos(d4);
        return;
    }

    public void toGeographic(Point3D point3D) throws CalculationException {
        point3D.y -= this.a;
        point3D.x -= this.b;
        double d2 = Math.atan(point3D.x / (this.c - point3D.y));
        double d3 = this.c - point3D.y;
        double d4 = Math.sqrt(point3D.x * point3D.x + d3 * d3);
        double d5 = d4 * this.d / this._ellipsoid.semiMajor();
        double d6 = (this.j - d5 * d5) / this.d;
        point3D.x = this.e + d2 / this.d;
        if (this._ellipsoid.isSphere()) {
            point3D.y = Math.asin(d6 / 2.0);
        } else {
            double d7 = d6 / this.i;
            if (Math.abs(d7) >= 1.0) {
                point3D.y = Utilities.signum(d6) * 1.5707963267948966;
            } else {
                double d8 = Math.asin(d7);
                point3D.y = this._ellipsoid.authalicToLatitude(d8);
            }
        }
        return;
    }

    public void init() throws ValidationException {
        double d2;
        if (this._ellipsoid == null) {
            return;
        }
        if (Utilities.angleIsZero(this.g) && Utilities.angleIsZero(this.f)) {
            throw new ValidationMessageException(Resource.formatMessage0("AEANorthAndSouthParallelsOnEquator"));
        }
        this.makeHorizon(this.e, -1.5707963267948966, 1.5707963267948966);
        if (this._ellipsoid.isSphere()) {
            double d3 = Math.cos(this.g);
            this.d = (Math.sin(this.g) + Math.sin(this.f)) / 2.0;
            this.j = d3 * d3 + 2.0 * this.d * Math.sin(this.g);
            d2 = 2.0 * Math.sin(this.h);
        } else {
            double d4 = this._ellipsoid.m(this.g);
            double d5 = this._ellipsoid.m(this.f);
            d2 = this._ellipsoid.calcQ(this.h);
            double d6 = this._ellipsoid.calcQ(this.g);
            double d7 = this._ellipsoid.calcQ(this.f);
            this.d = Utilities.angleIsZero(this.g - this.f) ? Math.sin(this.g) : (d4 * d4 - d5 * d5) / (d7 - d6);
            this.j = d4 * d4 + this.d * d6;
            double d8 = this._ellipsoid.eccentricity();
            double d9 = this._ellipsoid.eccentricitySquared();
            this.i = 1.0 - (1.0 - d9) / (2.0 * d8) * Math.log((1.0 - d8) / (1.0 + d8));
        }
        this.c = this._ellipsoid.semiMajor() * Math.sqrt(this.j - this.d * d2) / this.d;
        if (this.d < 0.0) {
            this.makeHorizon(this.e, -1.5707963267948966, 1.0471975511965979);
        } else {
            this.makeHorizon(this.e, -1.0471975511965979, 1.5707963267948966);
        }
        return;
    }

    public AlbersEqualArea(Ellipsoid ellipsoid, double d2, double d3, double d4, double d5, double d6, double d7) throws ValidationException {
        this._ellipsoid = ellipsoid;
        this.b = d6;
        this.a = d7;
        this.e = d2;
        this.h = d3;
        this.g = d4;
        this.f = d5;
        this.init();
    }

    public GeodeticObject createObject(GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        return new AlbersEqualArea(this.getSchema(), geodeticRow, n2);
    }

    public Object clone() {
        AlbersEqualArea albersEqualArea = null;
        albersEqualArea = (AlbersEqualArea)super.clone();
        albersEqualArea.e = this.e;
        albersEqualArea.h = this.h;
        albersEqualArea.g = this.g;
        albersEqualArea.f = this.f;
        albersEqualArea.a = this.a;
        albersEqualArea.b = this.b;
        try {
            albersEqualArea.init();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return albersEqualArea;
    }

    public GeodeticObject createObject(Unit unit, Unit unit2, String[] stringArray, int n2) throws InvalidDataException {
        return new AlbersEqualArea(unit, unit2, stringArray, n2, this.getSchema());
    }

    protected void assignValues() {
        super.assignValues();
        this.setValue(2, this.e);
        this.setValue(3, this.h);
        this.setValue(4, this.f);
        this.setValue(5, this.g);
        this.setValue(6, this.b);
        this.setValue(7, this.a);
        return;
    }

    private void a() {
        this.e = this.getValue(2);
        this.g = this.getValue(5);
        this.f = this.getValue(4);
        this.h = this.getValue(3);
        this.b = this.getValue(6);
        this.a = this.getValue(7);
        return;
    }

    public AlbersEqualArea(Unit unit, Unit unit2, String[] stringArray, int n2, ProjectionSchema projectionSchema) throws InvalidDataException {
        super(unit, unit2, stringArray, n2, projectionSchema);
        this.a();
    }

    public AlbersEqualArea(ProjectionSchema projectionSchema, GeodeticRow geodeticRow, int n2) throws InvalidRowDataException {
        super(projectionSchema, geodeticRow, n2);
        this.a();
    }

    AlbersEqualArea() {
    }
}

