/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.axl.map;

import com.esri.mo.axl.map.SymbolElement;
import com.esri.mo.axl.map.Util;
import java.awt.Color;

public class SimplePolygonSymbolElement
extends SymbolElement {
    public static final String TagName = "SIMPLEPOLYGONSYMBOL";

    public boolean hasTransparencyAttribute() {
        return false == Util.isEmptyAttribute(this.getAttribute("transparency"));
    }

    public double getTransparency() {
        return Util.stringToDouble(this.getAttribute("transparency"), 1.0);
    }

    public void setTransparency(double d2) {
        this.setAttribute("transparency", Util.doubleToString(d2));
        return;
    }

    public double getBoundaryTransparency() {
        return Util.stringToDouble(this.getAttribute("boundarytransparency"), 1.0);
    }

    public void setBoundaryTransparency(double d2) {
        this.setAttribute("boundarytransparency", Util.doubleToString(d2));
        return;
    }

    public double getFillTransparency() {
        return Util.stringToDouble(this.getAttribute("filltransparency"), 1.0);
    }

    public void setFillTransparency(double d2) {
        this.setAttribute("filltransparency", Util.doubleToString(d2));
        return;
    }

    public double getFillInterval() {
        try {
            if (Integer.parseInt(this.getAttribute("fillinterval")) < 2) {
                return 2.0;
            }
            return Integer.parseInt(this.getAttribute("fillinterval"));
        }
        catch (Exception exception) {
            return 6.0;
        }
    }

    public void setFillInterval(int n2) {
        this.setAttribute("fillinterval", new Integer(n2).toString());
        return;
    }

    public String getFillType() {
        String string = this.getAttribute("filltype");
        if (Util.isEmptyAttribute(string)) {
            return "solid";
        }
        return string;
    }

    public void setFillType(String string) {
        this.setAttribute("filltype", string);
        return;
    }

    public Color getFillColor() {
        String string = this.getAttribute("fillcolor");
        return Util.getColor(string, new Color(0, 200, 0));
    }

    public void setFillColor(int n2, int n3, int n4) {
        String string = Util.setColor(n2, n3, n4, 255);
        this.setAttribute("fillcolor", string);
        return;
    }

    public void setFillColor(Color color) {
        if (color == null) {
            color = Color.gray;
        }
        String string = Util.setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        this.setAttribute("fillcolor", string);
        return;
    }

    public String getBoundaryJoinType() {
        String string = this.getAttribute("boundaryjointype");
        if (Util.isEmptyAttribute(string)) {
            return "round";
        }
        return string;
    }

    public void setBoundaryJoinType(String string) {
        this.setAttribute("boundaryjointype", string);
        return;
    }

    public String getBoundaryCapType() {
        String string = this.getAttribute("boundarycaptype");
        if (Util.isEmptyAttribute(string)) {
            return "butt";
        }
        return string;
    }

    public void setBoundaryCapType(String string) {
        this.setAttribute("boundarycaptype", string);
        return;
    }

    public String getBoundaryType() {
        String string = this.getAttribute("boundarytype");
        if (Util.isEmptyAttribute(string)) {
            return "solid";
        }
        return string;
    }

    public void setBoundaryType(String string) {
        this.setAttribute("boundarytype", string);
        return;
    }

    public Color getBoundaryColor() {
        String string = this.getAttribute("boundarycolor");
        return Util.getColor(string, Color.black);
    }

    public void setBoundaryColor(int n2, int n3, int n4) {
        String string = Util.setColor(n2, n3, n4, 255);
        this.setAttribute("boundarycolor", string);
        return;
    }

    public void setBoundaryColor(Color color) {
        String string = Util.setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        this.setAttribute("boundarycolor", string);
        return;
    }

    public void setBoundary(boolean bl) {
        this.setAttribute("boundary", new Boolean(bl).toString());
        return;
    }

    public boolean getBoundary() {
        String string = this.getAttribute("boundary");
        if (Util.isEmptyAttribute(string)) {
            return true;
        }
        try {
            return new Boolean(string);
        }
        catch (Exception exception) {
            return true;
        }
    }

    public int getBoundaryWidth() {
        try {
            return Integer.parseInt(this.getAttribute("boundarywidth"));
        }
        catch (Exception exception) {
            return 1;
        }
    }

    public void setBoundaryWidth(int n2) {
        this.setAttribute("boundarywidth", new Integer(n2).toString());
        return;
    }
}

