/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.axl.map;

import com.esri.mo.axl.map.IncompleteDictionaryException;
import com.esri.mo.axl.map.RangeElement;
import com.esri.mo.axl.map.SymbolElement;
import com.esri.mo.data.feat.Field;
import com.esri.mo.data.qb.QueryEnvironment;
import com.esri.mo.map.draw.BaseRange;
import com.esri.mo.map.draw.BaseSymbol;
import com.esri.mo.map.draw.LegendClass;
import com.esri.mo.map.draw.Range;
import com.esri.mo.map.draw.Symbol;
import com.sun.xml.tree.XmlDocument;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;

public class RangeHelper {
    public static Symbol getSymbol(RangeElement rangeElement) throws IOException {
        return BaseSymbol.createSymbolFromAXL(rangeElement.getSymbol());
    }

    public static Range fromAXL(RangeElement rangeElement, Field field) throws IOException {
        if (field == null || rangeElement == null) {
            throw new IllegalArgumentException();
        }
        try {
            String string = QueryEnvironment.preparse(rangeElement.getLower());
            String string2 = QueryEnvironment.preparse(rangeElement.getUpper());
            if (field.isDate()) {
                string = QueryEnvironment.stripQuotes(string);
                string2 = QueryEnvironment.stripQuotes(string2);
            }
            Object object = field.parse(string, Locale.getDefault());
            Object object2 = field.parse(string2, Locale.getDefault());
            return new BaseRange((Comparable)object, (Comparable)object2, rangeElement.getEquality());
        }
        catch (ParseException parseException) {
            throw new IOException(parseException.toString());
        }
    }

    public static RangeElement toAXL(XmlDocument xmlDocument, LegendClass legendClass, Field field) throws IOException {
        if (xmlDocument == null || legendClass == null) {
            throw new IllegalArgumentException();
        }
        RangeElement rangeElement = (RangeElement)((Object)xmlDocument.createElement("RANGE"));
        if (rangeElement == null) {
            throw new IncompleteDictionaryException();
        }
        Range range = (Range)legendClass.getValue();
        if (range == null) {
            throw new IllegalArgumentException();
        }
        String string = null;
        String string2 = null;
        if (field.isDate()) {
            string = QueryEnvironment.encodeDate((Date)range.getLower());
            string2 = QueryEnvironment.encodeDate((Date)range.getUpper());
        } else {
            string = field.format(range.getLower(), Locale.US);
            string2 = field.format(range.getUpper(), Locale.US);
        }
        rangeElement.setLower(string);
        rangeElement.setUpper(string2);
        if (!range.getEquality().equalsIgnoreCase("lower")) {
            rangeElement.setEquality(range.getEquality());
        }
        rangeElement.setSymbol((SymbolElement)legendClass.getSymbol().toAXL(xmlDocument));
        if (legendClass.getLabel() != null) {
            rangeElement.setLabel(legendClass.getLabel());
        }
        return rangeElement;
    }
}

