/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.axl.map;

import com.esri.mo.axl.map.ExactElement;
import com.esri.mo.axl.map.IncompleteDictionaryException;
import com.esri.mo.axl.map.SymbolElement;
import com.esri.mo.data.feat.Field;
import com.esri.mo.data.qb.QueryEnvironment;
import com.esri.mo.map.draw.BaseSymbol;
import com.esri.mo.map.draw.LegendClass;
import com.esri.mo.map.draw.Symbol;
import com.sun.xml.tree.XmlDocument;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;

public class ExactHelper {
    public static Symbol getSymbol(ExactElement exactElement) throws IOException {
        if (exactElement == null) {
            throw new IllegalArgumentException();
        }
        return BaseSymbol.createSymbolFromAXL(exactElement.getSymbol());
    }

    public static Object getValue(ExactElement exactElement, Field field) throws IOException {
        if (exactElement == null || field == null) {
            throw new IllegalArgumentException();
        }
        try {
            String string = QueryEnvironment.preparse(exactElement.getValue());
            if (field.isDate()) {
                string = QueryEnvironment.stripQuotes(string);
            }
            return field.parse(string, Locale.getDefault());
        }
        catch (ParseException parseException) {
            throw new IOException(parseException.toString());
        }
    }

    public static ExactElement toAXL(XmlDocument xmlDocument, LegendClass legendClass, Field field) throws IOException {
        if (xmlDocument == null || legendClass == null) {
            throw new IllegalArgumentException();
        }
        ExactElement exactElement = (ExactElement)((Object)xmlDocument.createElement("EXACT"));
        if (exactElement == null) {
            throw new IncompleteDictionaryException();
        }
        String string = null;
        string = field.isDate() ? QueryEnvironment.encodeDate((Date)legendClass.getValue()) : field.format(legendClass.getValue(), Locale.US);
        exactElement.setValue(string);
        exactElement.setSymbol((SymbolElement)legendClass.getSymbol().toAXL(xmlDocument));
        if (legendClass.getLabel() != null) {
            exactElement.setLabel(legendClass.getLabel());
        }
        return exactElement;
    }
}

