/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.axl.geom;

import com.esri.mo.axl.geom.GeometryElement;
import com.esri.mo.axl.map.CreatableFromAXL;
import com.esri.mo.axl.map.RasterMarkerSymbolElement;
import com.esri.mo.axl.map.SimpleMarkerSymbolElement;
import com.esri.mo.axl.map.TrueTypeMarkerSymbolElement;
import com.esri.mo.axl.map.Util;
import com.esri.mo.cs.geom.FeatureGeometry;
import com.esri.mo.cs.geom.Point;
import com.esri.mo.map.dpy.AcetatePoint;
import com.esri.mo.map.dpy.Element;
import com.esri.mo.util.MessageCentre;
import com.sun.xml.tree.ElementNode;

public class PointElement
extends GeometryElement
implements CreatableFromAXL {
    private double a;
    private double b;
    public static final String TagName = "POINT";

    public TrueTypeMarkerSymbolElement getTrueTypeMarkerSymbol() {
        return (TrueTypeMarkerSymbolElement)Util.getFirstChildNodeByTagName(this, "TRUETYPEMARKERSYMBOL");
    }

    public void setTrueTypeMarkerSymbol(TrueTypeMarkerSymbolElement trueTypeMarkerSymbolElement) {
        Util.replaceChild(this, trueTypeMarkerSymbolElement, this.getTrueTypeMarkerSymbol());
        return;
    }

    public SimpleMarkerSymbolElement getSimpleMarkerSymbol() {
        return (SimpleMarkerSymbolElement)Util.getFirstChildNodeByTagName(this, "SIMPLEMARKERSYMBOL");
    }

    public void setSimpleMarkerSymbol(SimpleMarkerSymbolElement simpleMarkerSymbolElement) {
        Util.replaceChild(this, simpleMarkerSymbolElement, this.getSimpleMarkerSymbol());
        return;
    }

    public RasterMarkerSymbolElement getRasterMarkerSymbol() {
        return (RasterMarkerSymbolElement)Util.getFirstChildNodeByTagName(this, "RASTERMARKERSYMBOL");
    }

    public void setRasterMarkerSymbol(RasterMarkerSymbolElement rasterMarkerSymbolElement) {
        Util.replaceChild(this, rasterMarkerSymbolElement, this.getRasterMarkerSymbol());
        return;
    }

    public ElementNode getSymbolElement() {
        if (this.getTrueTypeMarkerSymbol() != null) {
            return this.getTrueTypeMarkerSymbol();
        }
        if (this.getSimpleMarkerSymbol() != null) {
            return this.getSimpleMarkerSymbol();
        }
        if (this.getRasterMarkerSymbol() != null) {
            return this.getRasterMarkerSymbol();
        }
        return null;
    }

    public void setSymbolElement(ElementNode elementNode) {
        if (elementNode instanceof RasterMarkerSymbolElement) {
            this.setRasterMarkerSymbol((RasterMarkerSymbolElement)elementNode);
        }
        if (elementNode instanceof SimpleMarkerSymbolElement) {
            this.setSimpleMarkerSymbol((SimpleMarkerSymbolElement)elementNode);
        }
        if (elementNode instanceof TrueTypeMarkerSymbolElement) {
            this.setTrueTypeMarkerSymbol((TrueTypeMarkerSymbolElement)elementNode);
        }
        return;
    }

    public Element createFromAXL() {
        AcetatePoint acetatePoint = new AcetatePoint();
        try {
            acetatePoint.fromAXL(this);
        }
        catch (Exception exception) {
            MessageCentre.get().log(this, exception);
            return null;
        }
        return acetatePoint;
    }

    public FeatureGeometry createGeometryFromAXL() {
        Point point = new Point();
        try {
            point.fromAXL(this);
        }
        catch (Exception exception) {
            MessageCentre.get().log(this, exception);
            return null;
        }
        return point;
    }

    public double getY() {
        return Util.stringToDouble(this.getAttribute("y"), 0.0);
    }

    public void setY(double d2) {
        this.setAttribute("y", Util.doubleToString(d2));
        return;
    }

    public double getX() {
        return Util.stringToDouble(this.getAttribute("x"), 0.0);
    }

    public void setX(double d2) {
        this.setAttribute("x", Util.doubleToString(d2));
        return;
    }

    public void set(double d2, double d3) {
        this.setX(d2);
        this.setY(d3);
        return;
    }

    public String getCoord() {
        return Util.replaceSeparators(this.getAttribute("coords"));
    }

    public void setCoord(String string) {
        this.setAttribute("coords", string);
        return;
    }
}

