/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.axl.geom;

import com.esri.mo.axl.geom.GeometryElement;
import com.esri.mo.axl.map.Util;
import com.esri.mo.cs.geom.Envelope;
import com.esri.mo.cs.geom.FeatureGeometry;
import com.esri.mo.util.MessageCentre;

public class EnvelopeElement
extends GeometryElement {
    private double d;
    private double e;
    private double b;
    private double c;
    private boolean a;
    public static final String TagName = "ENVELOPE";

    public FeatureGeometry createGeometryFromAXL() {
        Envelope envelope = new Envelope();
        try {
            envelope.fromAXL(this);
        }
        catch (Exception exception) {
            MessageCentre.get().log((Object)this, exception);
            return null;
        }
        return envelope;
    }

    public boolean getReaspect() {
        return new Boolean(this.getAttribute("reaspect"));
    }

    public void setReaspect(boolean bl) {
        this.setAttribute("reaspect", new Boolean(bl).toString());
        return;
    }

    public double getMaxY() {
        return Util.stringToDouble(this.getAttribute("maxy"), 100.0);
    }

    public void setMaxY(double d2) {
        this.setAttribute("maxy", Util.doubleToString(d2));
        return;
    }

    public double getMaxX() {
        return Util.stringToDouble(this.getAttribute("maxx"), 100.0);
    }

    public void setMaxX(double d2) {
        this.setAttribute("maxx", Util.doubleToString(d2));
        return;
    }

    public double getMinY() {
        return Util.stringToDouble(this.getAttribute("miny"), 0.0);
    }

    public void setMinY(double d2) {
        this.setAttribute("miny", Util.doubleToString(d2));
        return;
    }

    public double getMinX() {
        return Util.stringToDouble(this.getAttribute("minx"), 0.0);
    }

    public void setMinX(double d2) {
        this.setAttribute("minx", Util.doubleToString(d2));
        return;
    }

    public void set(Envelope envelope) {
        this.set(envelope.x, envelope.y, envelope.getXMax(), envelope.getYMax());
        return;
    }

    public void set(double d2, double d3, double d4, double d5) {
        this.setMinX(d2);
        this.setMinY(d3);
        this.setMaxX(d4);
        this.setMaxY(d5);
        return;
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public void setName(String string) {
        this.setAttribute("name", string);
        return;
    }

    public Envelope createEnvelope() {
        return new Envelope(this.getMinX(), this.getMinY(), this.getMaxX() - this.getMinX(), this.getMaxY() - this.getMinY());
    }
}

